/*
 * Decompiled with CFR 0.152.
 */
package net.xstopho.resource_cracker.rendering;

import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.xstopho.resource_cracker.CrackerConstants;
import net.xstopho.resource_cracker.rendering.ScytheBakedModel;

@OnlyIn(value=Dist.CLIENT)
public class ScytheBakedModelRenderer {
    @SubscribeEvent
    public static void onRegisterModel(ModelEvent.RegisterAdditional event) {
        event.register(ScytheBakedModelRenderer.location("item/in_hand/scythe_copper"));
        event.register(ScytheBakedModelRenderer.location("item/in_hand/scythe_gold"));
        event.register(ScytheBakedModelRenderer.location("item/in_hand/scythe_iron"));
        event.register(ScytheBakedModelRenderer.location("item/in_hand/scythe_steel"));
        event.register(ScytheBakedModelRenderer.location("item/in_hand/scythe_diamond"));
        event.register(ScytheBakedModelRenderer.location("item/in_hand/scythe_netherite"));
    }

    @SubscribeEvent
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        ScytheBakedModelRenderer.add(event, "scythe_copper");
        ScytheBakedModelRenderer.add(event, "scythe_gold");
        ScytheBakedModelRenderer.add(event, "scythe_iron");
        ScytheBakedModelRenderer.add(event, "scythe_steel");
        ScytheBakedModelRenderer.add(event, "scythe_diamond");
        ScytheBakedModelRenderer.add(event, "scythe_netherite");
    }

    private static void add(ModelEvent.ModifyBakingResult event, String id) {
        event.getModels().put(ScytheBakedModelRenderer.location(id), new ScytheBakedModel(id, event.getModels()));
    }

    private static ModelResourceLocation location(String path) {
        ModelResourceLocation loc = ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"resource_cracker", (String)path));
        CrackerConstants.LOGGER.debug(loc.id().getPath());
        return loc;
    }
}

