/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.powerup;

import com.daqem.jobsplus.client.components.jobs.JobsComponent;
import com.daqem.jobsplus.client.components.powerup.PowerupHoverComponent;
import com.daqem.jobsplus.client.components.powerup.PowerupIconComponent;
import com.daqem.jobsplus.client.components.powerup.PowerupTreeComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PowerupComponent
extends AbstractComponent<PowerupComponent> {
    public static final int SIZE = 26;
    public static final int SPACING = 2;
    private final PowerupComponent previousSibling;
    @Nullable
    private final PowerupComponent powerupComponentParent;
    private final PowerupTreeComponent treeComponent;
    private final Powerup powerup;
    private final JobsScreenOptions options;
    private final int childIndex;
    private PowerupComponent ancestor;
    @Nullable
    private PowerupComponent thread;
    private final PowerupIconComponent iconComponent;
    private final PowerupHoverComponent hoverComponent;
    private float mod;
    private float change;
    private float shift;
    private float posX;
    private float posY;

    public PowerupComponent(Powerup powerup, PowerupTreeComponent parent, @Nullable PowerupComponent powerupComponentParent, PowerupComponent previousSibling, int childIndex, int x, JobsScreenOptions options) {
        super(null, x, -1, 26, 26);
        this.powerupComponentParent = powerupComponentParent;
        this.powerup = powerup;
        this.options = options;
        this.previousSibling = previousSibling;
        this.treeComponent = parent;
        this.childIndex = childIndex;
        this.ancestor = this;
        this.iconComponent = new PowerupIconComponent(0, 0, powerup.getPowerupInstance().getIcon(), powerup.getState(), powerup.getPowerupInstance().getPowerupType(), options);
        this.hoverComponent = new PowerupHoverComponent(0, 0, Minecraft.getInstance().font, powerup.getPowerupInstance().getIcon(), (Component)powerup.getPowerupInstance().getName(), (Component)powerup.getPowerupInstance().getDescription(), powerup.getState(), powerup.getPowerupInstance().getPowerupType(), powerup.getPowerupInstance().getRequiredLevel(), powerup.getPowerupInstance().getPrice(), options);
        this.addChildren(this.getPowerupChildren(powerup));
        this.addChildren(new IComponent[]{this.iconComponent});
    }

    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        JobsComponent jobsComponent;
        IComponent iComponent;
        if (this.iconComponent.isTotalHovered(mouseX, mouseY) && this.treeComponent.getParent().isTotalHovered((double)mouseX, (double)mouseY) && this.treeComponent.getParent().getParent().isVisible() && (iComponent = this.treeComponent.getParent().getParent().getParent()) instanceof JobsComponent && !(jobsComponent = (JobsComponent)iComponent).getModalComponent().isVisible()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)this.getTotalX(), (float)this.getTotalY(), 0.0f);
            this.hoverComponent.renderBase(guiGraphics, mouseX, mouseY, delta);
            guiGraphics.pose().popPose();
        }
    }

    public PowerupHoverComponent getHoverComponent() {
        return this.hoverComponent;
    }

    public PowerupIconComponent getIconComponent() {
        return this.iconComponent;
    }

    public PowerupTreeComponent getTreeComponent() {
        return this.treeComponent;
    }

    public Powerup getPowerup() {
        return this.powerup;
    }

    private List<IComponent<?>> getPowerupChildren(Powerup powerup) {
        ArrayList children = new ArrayList();
        PowerupComponent previousSibling = null;
        ResourceLocation parentLocation = this.powerupComponentParent == null ? null : powerup.getPowerupInstance().getLocation();
        List<PowerupInstance> allPowerupInstances = this.options.getSelectedJob().getJobInstance().getPowerups();
        List<Powerup> allPowerups = this.options.getSelectedJob().getPowerupManager().getAllPowerups();
        Map powerupInstances = allPowerupInstances.stream().filter(x -> parentLocation == null ? x.getParentLocation() == null : parentLocation.equals((Object)x.getParentLocation())).collect(HashMap::new, (map, powerup1) -> map.put(powerup1.getLocation(), powerup1), HashMap::putAll);
        Map powerups = allPowerups.stream().filter(x -> parentLocation == null ? x.getPowerupInstance().getParentLocation() == null : parentLocation.equals((Object)x.getPowerupInstance().getParentLocation())).collect(HashMap::new, (map, powerup1) -> map.put(powerup1.getPowerupInstance().getLocation(), powerup1), HashMap::putAll);
        for (Map.Entry entry : powerupInstances.entrySet()) {
            if (powerups.containsKey(entry.getKey())) continue;
            PowerupState state = PowerupState.NOT_OWNED;
            if (this.powerup.getState() == PowerupState.LOCKED || this.powerup.getState() == PowerupState.NOT_OWNED) {
                state = PowerupState.LOCKED;
            }
            Powerup powerup12 = new Powerup((PowerupInstance)((Object)entry.getValue()), state);
            powerups.put((ResourceLocation)entry.getKey(), powerup12);
        }
        for (Powerup child : powerups.values()) {
            PowerupComponent powerupComponent;
            previousSibling = powerupComponent = new PowerupComponent(child, this.treeComponent, this, previousSibling, children.size(), (int)(this.posX + 1.0f), this.options);
            children.add((IComponent<?>)powerupComponent);
        }
        return children;
    }

    private List<PowerupComponent> getPowerupChildren() {
        return this.getChildren().stream().filter(PowerupComponent.class::isInstance).map(PowerupComponent.class::cast).toList();
    }

    public List<PowerupComponent> getAllPowerupChildren() {
        ArrayList<PowerupComponent> powerupComponents = new ArrayList<PowerupComponent>();
        powerupComponents.add(this);
        for (PowerupComponent powerupComponent : this.getPowerupChildren()) {
            powerupComponents.addAll(powerupComponent.getAllPowerupChildren());
        }
        return powerupComponents;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (PowerupComponent powerupChild : this.getPowerupChildren()) {
            this.drawConnectivity(graphics, 1, 0, powerupChild.getX() + 1, powerupChild.getY(), false);
        }
        for (PowerupComponent powerupChild : this.getPowerupChildren()) {
            this.drawConnectivity(graphics, 1, 0, powerupChild.getX() + 1, powerupChild.getY(), true);
        }
    }

    public void firstWalk() {
        List<PowerupComponent> powerupChildren = this.getPowerupChildren();
        if (powerupChildren.isEmpty()) {
            this.posY = this.previousSibling != null ? this.previousSibling.posY + 1.0f : 0.0f;
        } else {
            PowerupComponent treeNodePosition = null;
            for (PowerupComponent treeNodePosition2 : powerupChildren) {
                treeNodePosition2.firstWalk();
                treeNodePosition = treeNodePosition2.apportion(treeNodePosition == null ? treeNodePosition2 : treeNodePosition);
            }
            this.executeShifts();
            float f = (powerupChildren.getFirst().posY + powerupChildren.getLast().posY) / 2.0f;
            if (this.previousSibling != null) {
                this.posY = this.previousSibling.posY + 1.0f;
                this.mod = this.posY - f;
            } else {
                this.posY = f;
            }
        }
    }

    public float secondWalk(float f, int i, float g) {
        this.posY += f;
        this.posX = i;
        if (this.posY < g) {
            g = this.posY;
        }
        for (PowerupComponent treeNodePosition : this.getPowerupChildren()) {
            g = treeNodePosition.secondWalk(f + this.mod, i + 1, g);
        }
        return g;
    }

    public void thirdWalk(float f) {
        this.posY += f;
        for (PowerupComponent treeNodePosition : this.getPowerupChildren()) {
            treeNodePosition.thirdWalk(f);
        }
    }

    public void finalizePosition() {
        this.posY -= this.powerupComponentParent == null ? 0.0f : this.getTotalPosY() - this.posY;
        this.setX(28);
        this.setY((int)(this.posY * 28.0f));
        if (this.powerupComponentParent == null) {
            this.setX(this.getX() - 26 - 2);
        }
        if (!this.getPowerupChildren().isEmpty()) {
            for (PowerupComponent treeNodePosition : this.getPowerupChildren()) {
                treeNodePosition.finalizePosition();
            }
        }
    }

    private float getTotalPosY() {
        return this.posY + (this.powerupComponentParent == null ? 0.0f : this.powerupComponentParent.getTotalPosY());
    }

    private void executeShifts() {
        float f = 0.0f;
        float g = 0.0f;
        for (int i = this.getPowerupChildren().size() - 1; i >= 0; --i) {
            PowerupComponent treeNodePosition = this.getPowerupChildren().get(i);
            treeNodePosition.posY += f;
            treeNodePosition.mod += f;
            f += treeNodePosition.shift + (g += treeNodePosition.change);
        }
    }

    private PowerupComponent apportion(PowerupComponent treeNodePosition) {
        if (this.previousSibling != null && this.powerupComponentParent != null) {
            PowerupComponent treeNodePosition2 = this;
            PowerupComponent treeNodePosition3 = this;
            PowerupComponent treeNodePosition4 = this.previousSibling;
            PowerupComponent treeNodePosition5 = this.powerupComponentParent.getPowerupChildren().getFirst();
            float f = this.mod;
            float g = this.mod;
            float h = treeNodePosition4.mod;
            float i = treeNodePosition5.mod;
            while (treeNodePosition4.nextOrThread() != null && treeNodePosition2.previousOrThread() != null) {
                treeNodePosition4 = treeNodePosition4.nextOrThread();
                treeNodePosition2 = treeNodePosition2.previousOrThread();
                treeNodePosition5 = treeNodePosition5.previousOrThread();
                treeNodePosition3 = treeNodePosition3.nextOrThread();
                Objects.requireNonNull(treeNodePosition3).ancestor = this;
                float j = Objects.requireNonNull(treeNodePosition4).posY + h - (Objects.requireNonNull(treeNodePosition2).posY + f) + 1.0f;
                if (j > 0.0f) {
                    treeNodePosition4.getAncestor(this, treeNodePosition).moveSubtree(this, j);
                    f += j;
                    g += j;
                }
                h += treeNodePosition4.mod;
                f += treeNodePosition2.mod;
                i += Objects.requireNonNull(treeNodePosition5).mod;
                g += treeNodePosition3.mod;
            }
            if (treeNodePosition4.nextOrThread() != null && treeNodePosition3.nextOrThread() == null) {
                treeNodePosition3.thread = treeNodePosition4.nextOrThread();
                treeNodePosition3.mod += h - g;
            } else {
                if (treeNodePosition2.previousOrThread() != null && treeNodePosition5.previousOrThread() == null) {
                    treeNodePosition5.thread = treeNodePosition2.previousOrThread();
                    treeNodePosition5.mod += f - i;
                }
                treeNodePosition = this;
            }
        }
        return treeNodePosition;
    }

    @Nullable
    private PowerupComponent previousOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        List<PowerupComponent> powerupChildren = this.getPowerupChildren();
        return !powerupChildren.isEmpty() ? powerupChildren.getFirst() : null;
    }

    @Nullable
    private PowerupComponent nextOrThread() {
        if (this.thread != null) {
            return this.thread;
        }
        List<PowerupComponent> powerupChildren = this.getPowerupChildren();
        return !powerupChildren.isEmpty() ? powerupChildren.getLast() : null;
    }

    private PowerupComponent getAncestor(PowerupComponent treeNodePosition, PowerupComponent treeNodePosition2) {
        return this.ancestor != null && Objects.requireNonNull(treeNodePosition.powerupComponentParent).getPowerupChildren().contains((Object)this.ancestor) ? this.ancestor : treeNodePosition2;
    }

    private void moveSubtree(PowerupComponent treeNodePosition, float f) {
        float g = treeNodePosition.childIndex - this.childIndex;
        if (g != 0.0f) {
            treeNodePosition.change -= f / g;
            this.change += f / g;
        }
        treeNodePosition.shift += f;
        treeNodePosition.posY += f;
        treeNodePosition.mod += f;
    }

    private void drawConnectivity(GuiGraphics guiGraphics, int xFrom, int yFrom, int xTo, int yTo, boolean isWhite) {
        int color;
        int spacing = 2;
        int centerHeight = 12;
        int xOffset = 24;
        int xFromOffset = xFrom + xOffset;
        int xToOffset = xTo - 2;
        int yFromCenter = yFrom + centerHeight;
        int yToCenter = yTo + centerHeight;
        int n = color = isWhite ? -1 : -16777216;
        if (isWhite) {
            guiGraphics.hLine(xFromOffset, xFromOffset + spacing, yFromCenter, color);
            guiGraphics.vLine(xFromOffset + spacing, yFromCenter, yToCenter, color);
            guiGraphics.hLine(xToOffset, xToOffset + spacing, yToCenter, color);
        } else {
            guiGraphics.hLine(xFromOffset, xToOffset + 1, yFromCenter - 1, color);
            guiGraphics.hLine(xFromOffset, xToOffset + 1, yFromCenter, color);
            guiGraphics.hLine(xFromOffset, xToOffset + 1, yFromCenter + 1, color);
            guiGraphics.vLine(xToOffset - 1, yToCenter, yFromCenter, color);
            guiGraphics.vLine(xToOffset + 1, yToCenter, yFromCenter, color);
            guiGraphics.hLine(xToOffset - 1, xToOffset + spacing, yToCenter - 1, color);
            guiGraphics.hLine(xToOffset - 1, xToOffset + spacing, yToCenter, color);
            guiGraphics.hLine(xToOffset - 1, xToOffset + spacing, yToCenter + 1, color);
        }
    }

    public void setState(PowerupState powerupState) {
        this.iconComponent.setState(powerupState);
        this.hoverComponent.setState(powerupState);
    }
}

