/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.powerup;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.ModalComponent;
import com.daqem.jobsplus.client.components.SpriteComponent;
import com.daqem.jobsplus.client.components.jobs.JobsComponent;
import com.daqem.jobsplus.client.components.powerup.PowerupComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.client.screen.job.tab.RightTab;
import com.daqem.jobsplus.client.textures.JobsPlusTextures;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.c2s.ServerboundStartPowerupPacket;
import com.daqem.jobsplus.networking.c2s.ServerboundTogglePowerUpPacket;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.daqem.jobsplus.player.job.powerup.PowerupType;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.client.gui.component.ItemComponent;
import com.daqem.uilib.client.gui.component.io.ButtonComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PowerupIconComponent
extends SpriteComponent {
    private final PowerupType type;
    private PowerupState state;
    private JobsScreenOptions options;
    private boolean isClicked = false;
    private long clickedAt;
    private double mouseX;
    private double mouseY;

    public PowerupIconComponent(int x, int y, ItemStack itemStack, PowerupState state, PowerupType type, JobsScreenOptions options) {
        super(PowerupIconComponent.getSprite(state, type), x, y, 26, 26);
        this.state = state;
        this.type = type;
        this.options = options;
        ItemComponent itemComponent = new ItemComponent(5, 5, itemStack, true);
        this.addChildren(new IComponent[]{itemComponent});
        this.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            this.isClicked = true;
            this.clickedAt = System.currentTimeMillis();
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            return true;
        });
        this.setOnMouseReleaseEvent((mouseObject, screen, mouseX, mouseY, button) -> {
            PowerupComponent powerupComponent;
            if (this.isClicked && Math.abs(this.mouseX - mouseX) <= 2.0 && Math.abs(this.mouseY - mouseY) <= 2.0 && System.currentTimeMillis() - this.clickedAt < 500L && !((Object)((Object)(powerupComponent = (PowerupComponent)this.getParent()).getTreeComponent().getRootPowerupComponent())).equals((Object)powerupComponent)) {
                JobInstance jobInstance = options.getSelectedJob().getJobInstance();
                PowerupInstance powerupInstance = powerupComponent.getPowerup().getPowerupInstance();
                if (this.getState() == PowerupState.NOT_OWNED) {
                    JobsComponent jobsComponent = (JobsComponent)((PowerupComponent)this.getParent()).getTreeComponent().getParent().getParent().getParent();
                    if (options.getCoins() < (double)powerupInstance.getPrice()) {
                        jobsComponent.openModal((Component)JobsPlus.translatable("gui.jobs.not_enough_coins.title"), (Component)JobsPlus.translatable("gui.jobs.not_enough_coins.description"), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject, screen1, mouseX1, mouseY1, button1) -> {
                            ModalComponent modal = (ModalComponent)clickedObject.getParent();
                            if (modal != null) {
                                modal.close();
                            }
                            return true;
                        }), true);
                    } else if (options.getSelectedJob().getLevel() < powerupInstance.getRequiredLevel()) {
                        jobsComponent.openModal((Component)JobsPlus.translatable("gui.jobs.not_high_enough_level.title"), (Component)JobsPlus.translatable("gui.jobs.not_high_enough_level.description"), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject, screen1, mouseX1, mouseY1, button1) -> {
                            ModalComponent modal = (ModalComponent)clickedObject.getParent();
                            if (modal != null) {
                                modal.close();
                            }
                            return true;
                        }), true);
                    } else {
                        jobsComponent.openModal((Component)JobsPlus.translatable("gui.job.powerup.start"), (Component)JobsPlus.translatable("gui.job.powerup.start.description", powerupInstance.getName().withColor(jobInstance.getColorDecimal()), JobsPlus.literal(String.valueOf(powerupInstance.getPrice())).withColor(jobInstance.getColorDecimal())), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject, screen1, mouseX1, mouseY1, button1) -> {
                            ModalComponent modal = (ModalComponent)clickedObject.getParent();
                            if (modal != null) {
                                NetworkManager.sendToServer((CustomPacketPayload)new ServerboundStartPowerupPacket(jobInstance, powerupInstance));
                                options.setCoins(options.getCoins() - (double)powerupInstance.getPrice());
                                powerupComponent.setState(PowerupState.ACTIVE);
                                powerupComponent.getChildren().stream().filter(child -> child instanceof PowerupComponent).map(child -> (PowerupComponent)((Object)((Object)((Object)child)))).forEach(child -> child.setState(PowerupState.NOT_OWNED));
                                modal.close();
                            }
                            return true;
                        }), false);
                    }
                } else if (this.getState() == PowerupState.ACTIVE) {
                    powerupComponent.setState(PowerupState.INACTIVE);
                    NetworkManager.sendToServer((CustomPacketPayload)new ServerboundTogglePowerUpPacket(jobInstance, powerupInstance));
                } else if (this.getState() == PowerupState.INACTIVE) {
                    powerupComponent.setState(PowerupState.ACTIVE);
                    NetworkManager.sendToServer((CustomPacketPayload)new ServerboundTogglePowerUpPacket(jobInstance, powerupInstance));
                }
            }
            this.isClicked = false;
            return true;
        });
    }

    private static ResourceLocation getSprite(PowerupState state, PowerupType type) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case PowerupState.ACTIVE -> {
                switch (type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_BASIC_ACTIVE;
                    }
                    case ADVANCED: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_ADVANCED_ACTIVE;
                    }
                    case MASTERY: 
                }
                yield JobsPlusTextures.Powerup.POWERUP_ICON_MASTERY_ACTIVE;
            }
            case PowerupState.INACTIVE -> {
                switch (type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_BASIC_INACTIVE;
                    }
                    case ADVANCED: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_ADVANCED_INACTIVE;
                    }
                    case MASTERY: 
                }
                yield JobsPlusTextures.Powerup.POWERUP_ICON_MASTERY_INACTIVE;
            }
            case PowerupState.LOCKED -> {
                switch (type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_BASIC_LOCKED;
                    }
                    case ADVANCED: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_ADVANCED_LOCKED;
                    }
                    case MASTERY: 
                }
                yield JobsPlusTextures.Powerup.POWERUP_ICON_MASTERY_LOCKED;
            }
            case PowerupState.NOT_OWNED -> {
                switch (type) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case BASIC: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_BASIC_NOT_OWNED;
                    }
                    case ADVANCED: {
                        yield JobsPlusTextures.Powerup.POWERUP_ICON_ADVANCED_NOT_OWNED;
                    }
                    case MASTERY: 
                }
                yield JobsPlusTextures.Powerup.POWERUP_ICON_MASTERY_NOT_OWNED;
            }
        };
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.state != PowerupState.LOCKED && this.isTotalHovered(mouseX, mouseY)) {
            RenderSystem.setShaderColor((float)0.85f, (float)0.85f, (float)0.85f, (float)1.0f);
        }
        super.render(graphics, mouseX, mouseY, delta);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public PowerupState getState() {
        return this.state;
    }

    public void setState(PowerupState powerupState) {
        this.state = powerupState;
        this.setSelectedSprite(PowerupIconComponent.getSprite(powerupState, this.type));
    }

    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.options.getSelectedRightTab() == RightTab.POWER_UPS) {
            return super.preformOnClickEvent(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean preformOnMouseReleaseEvent(double mouseX, double mouseY, int button) {
        if (this.options.getSelectedRightTab() == RightTab.POWER_UPS) {
            return super.preformOnMouseReleaseEvent(mouseX, mouseY, button);
        }
        return false;
    }
}

