/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.toast;

import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.jobsplus.JobsPlus;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ItemRestrictionUnlockedToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final long DISPLAY_TIME = 5000L;
    private final ItemRestriction itemRestriction;
    private long lastChanged;
    private boolean changed;

    public ItemRestrictionUnlockedToast(ItemRestriction itemRestriction) {
        this.itemRestriction = itemRestriction;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long l) {
        if (this.changed) {
            this.lastChanged = l;
            this.changed = false;
        }
        if (this.itemRestriction == null) {
            return Toast.Visibility.HIDE;
        }
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        guiGraphics.drawString(toastComponent.getMinecraft().font, this.itemRestriction.getIcon().getHoverName(), 30, 7, -11534256, false);
        guiGraphics.drawString(toastComponent.getMinecraft().font, (Component)JobsPlus.translatable("job.item_unlocked.toast"), 30, 18, -16777216, false);
        guiGraphics.renderFakeItem(this.itemRestriction.getIcon(), 8, 8);
        return (double)(l - this.lastChanged) >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public static void add(ToastComponent toastComponent, ItemRestriction itemRestriction) {
        toastComponent.addToast((Toast)new ItemRestrictionUnlockedToast(itemRestriction));
    }
}

