/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.config;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.impl.config.ConfigBuilder;

public class JobsPlusConfig {
    public static final IConfigEntry<Boolean> enableDefaultJobs;
    public static final IConfigEntry<Integer> amountOfFreeJobs;
    public static final IConfigEntry<Integer> maxJobs;
    public static final IConfigEntry<Boolean> broadcastLevelUpMessages;
    public static final IConfigEntry<Boolean> showXPInActionBar;
    public static final IConfigEntry<Double> xpMultiplier;
    public static final IConfigEntry<Boolean> useDecimalValuesForXP;
    public static final IConfigEntry<Double> coinsPerLevelUp;
    public static final IConfigEntry<Boolean> isDebug;

    public static void init() {
    }

    static {
        ConfigBuilder config = new ConfigBuilder("jobsplus", "jobsplus-common", ConfigExtension.YAML, ConfigType.COMMON);
        config.push("jobs");
        enableDefaultJobs = config.defineBoolean("enable_default_jobs", true).withComments(new String[]{"if true, the default jobs are enabled. WARNING: setting this to false will erase all the stats for these jobs"});
        amountOfFreeJobs = config.defineInteger("amount_of_free_jobs", 2, 0, Integer.MAX_VALUE).withComments(new String[]{"the amount of free jobs a player can have"});
        maxJobs = config.defineInteger("max_jobs", Integer.MAX_VALUE, 0, Integer.MAX_VALUE).withComments(new String[]{"the maximum amount of jobs a player can have"});
        broadcastLevelUpMessages = config.defineBoolean("broadcast_level_up_messages", true).withComments(new String[]{"if true, a message will be shown to all players when they level up a job"});
        config.push("experience");
        showXPInActionBar = config.defineBoolean("show_xp_in_action_bar", true).withComments(new String[]{"if true, the player's job XP gain will be shown in the action bar, when they gain XP"});
        xpMultiplier = config.defineDouble("xp_multiplier", 1.0, 0.0, Double.MAX_VALUE).withComments(new String[]{"multiplier for the amount of job XP a player gains"});
        useDecimalValuesForXP = config.defineBoolean("use_decimal_values_for_xp", false).withComments(new String[]{"if true, decimal values will be used for job XP."});
        config.pop();
        config.push("coins");
        coinsPerLevelUp = config.defineDouble("coins_per_level_up", 1.0, 0.0, Double.MAX_VALUE).withComments(new String[]{"the amount of coins a player gets when they level up a job"});
        config.pop();
        config.pop();
        config.push("debug");
        isDebug = config.defineBoolean("is_debug", false).withComments(new String[]{"if true, debug mode is enabled"});
        config.pop();
        config.build();
    }
}

