/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.s2c;

import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.client.screen.job.JobsScreen;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundOpenJobsScreenPacket
implements CustomPacketPayload {
    private final List<Job> jobs;
    private final double coins;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundOpenJobsScreenPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundOpenJobsScreenPacket>(){

        @NotNull
        public ClientboundOpenJobsScreenPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundOpenJobsScreenPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundOpenJobsScreenPacket packet) {
            buf.writeCollection(packet.jobs, Job.Serializer::toNetwork);
            buf.writeDouble(packet.coins);
        }
    };

    public ClientboundOpenJobsScreenPacket(List<Job> jobs, double coins) {
        this.jobs = jobs;
        this.coins = coins;
    }

    public ClientboundOpenJobsScreenPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this.jobs = friendlyByteBuf.readList(friendlyByteBuf1 -> Job.Serializer.fromNetwork(friendlyByteBuf1, null));
        this.coins = friendlyByteBuf.readDouble();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.CLIENTBOUND_OPEN_JOBS_SCREEN;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientboundOpenJobsScreenPacket packet, NetworkManager.PacketContext context) {
        @Nullable Screen previousScreen = null;
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof JobsScreen) {
            JobsScreen jobsScreen = (JobsScreen)screen;
            previousScreen = jobsScreen.getPreviousScreen();
        }
        Minecraft.getInstance().setScreen((Screen)new JobsScreen(new JobsScreenOptions(packet.jobs, packet.coins), previousScreen));
    }
}

