/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.sync.job;

import com.daqem.jobsplus.client.player.JobsClientPlayer;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClientboundRemoveJobPacket
implements CustomPacketPayload {
    private final JobInstance jobInstance;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundRemoveJobPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundRemoveJobPacket>(){

        @NotNull
        public ClientboundRemoveJobPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundRemoveJobPacket((FriendlyByteBuf)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundRemoveJobPacket packet) {
            boolean jobInstanceIsNotNull = packet.jobInstance != null;
            buf.writeBoolean(jobInstanceIsNotNull);
            if (jobInstanceIsNotNull) {
                buf.writeResourceLocation(packet.jobInstance.getLocation());
            }
        }
    };

    public ClientboundRemoveJobPacket(JobInstance jobInstance) {
        this.jobInstance = jobInstance;
    }

    public ClientboundRemoveJobPacket(FriendlyByteBuf friendlyByteBuf) {
        boolean jobInstanceIsNotNull = friendlyByteBuf.readBoolean();
        this.jobInstance = jobInstanceIsNotNull ? JobInstance.of(friendlyByteBuf.readResourceLocation()) : null;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.CLIENTBOUND_REMOVE_JOB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientboundRemoveJobPacket packet, NetworkManager.PacketContext context) {
        if (packet.jobInstance == null) {
            return;
        }
        Player player = context.getPlayer();
        if (player instanceof JobsClientPlayer) {
            JobsClientPlayer player2 = (JobsClientPlayer)player;
            player2.jobsplus$removeJob(packet.jobInstance);
        }
    }
}

