/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.player.job;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.event.triggers.JobEvents;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.sync.job.ClientboundUpdateJobPacket;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.exp.ExpCollector;
import com.daqem.jobsplus.player.job.powerup.JobPowerupManager;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class Job {
    private final JobInstance jobInstance;
    private final JobPowerupManager powerupManager;
    private JobsPlayer player;
    private int level;
    private double experience;
    private final ExpCollector expCollector = new ExpCollector();

    public Job(JobsPlayer player, JobInstance jobInstance) {
        this(player, jobInstance, 0, 0.0, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, double experience) {
        this(player, jobInstance, level, experience, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, ResourceLocation jobInstanceLocation, int level, double experience, @NotNull List<Powerup> powerups) {
        this(player, JobManager.getInstance().getJobs().get(jobInstanceLocation), level, experience, powerups);
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, double experience, @NotNull List<Powerup> powerups) {
        this.player = player;
        this.jobInstance = jobInstance;
        this.powerupManager = new JobPowerupManager(powerups);
        this.level = level;
        this.experience = experience;
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public JobPowerupManager getPowerupManager() {
        return this.powerupManager;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.syncWithClient();
    }

    public double getExperience() {
        return this.experience;
    }

    public void setExperience(double experience, boolean triggerEvent) {
        double change = experience - this.experience;
        if (!((Boolean)JobsPlusConfig.useDecimalValuesForXP.get()).booleanValue()) {
            change = Math.floor(change);
            experience = Math.floor(experience);
        }
        this.expCollector.addExp(change);
        this.experience = experience;
        this.checkForLevelUp();
        this.syncWithClient();
        if (triggerEvent) {
            JobEvents.onJobExperience(this.player, this, change);
        }
    }

    public void addExperience(double experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience * (Double)JobsPlusConfig.xpMultiplier.get(), true);
    }

    public void addExperienceWithoutEvent(double experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job without event.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience * (Double)JobsPlusConfig.xpMultiplier.get(), false);
    }

    private void checkForLevelUp() {
        int experienceToLevelUp = Job.getExperienceToLevelUp(this.level);
        if (this.experience >= (double)experienceToLevelUp) {
            this.setLevel(this.level + 1);
            this.setExperience(this.experience - (double)experienceToLevelUp, false);
            JobEvents.onJobLevelUp(this.player, this);
            JobsPlayer jobsPlayer = this.player;
            if (jobsPlayer instanceof JobsServerPlayer) {
                JobsServerPlayer serverPlayer = (JobsServerPlayer)jobsPlayer;
                serverPlayer.jobsplus$updateJobOnClient(this);
            }
        }
    }

    private void syncWithClient() {
        JobsPlayer jobsPlayer = this.player;
        if (jobsPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)jobsPlayer;
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientboundUpdateJobPacket(this));
        }
    }

    public static int getExperienceToLevelUp(int level) {
        if (level == 0) {
            return 0;
        }
        return (int)(100.0 + (double)(level * level) * 0.5791);
    }

    public void setPlayer(JobsPlayer player) {
        this.player = player;
    }

    public CompoundTag toNBT() {
        CompoundTag jobTag = new CompoundTag();
        jobTag.putString("JobInstanceLocation", this.getJobInstance().getLocation().toString());
        jobTag.putInt("Level", this.getLevel());
        jobTag.putDouble("Experience", this.getExperience());
        ListTag powerupsTag = new ListTag();
        for (Powerup powerup : this.powerupManager.getAllPowerups()) {
            if (powerup == null || powerup.getPowerupInstance() == null) continue;
            CompoundTag powerupTag = new CompoundTag();
            powerupTag.putString("PowerupLocation", powerup.getPowerupInstance().getLocation().toString());
            powerupTag.putString("State", powerup.getState().name());
            powerupsTag.add((Object)powerupTag);
        }
        jobTag.put("Powerups", (Tag)powerupsTag);
        return jobTag;
    }

    public static Job fromNBT(JobsPlayer player, CompoundTag tag) {
        ResourceLocation jobInstanceLocation = ResourceLocation.parse((String)tag.getString("JobInstanceLocation"));
        int level = tag.getInt("Level");
        double exp = tag.getDouble("Experience");
        ListTag powerupsTag = tag.getList("Powerups", 10);
        ArrayList<Powerup> powerups = new ArrayList<Powerup>();
        for (int i = 0; i < powerupsTag.size(); ++i) {
            CompoundTag powerupTag = powerupsTag.getCompound(i);
            ResourceLocation powerupLocation = ResourceLocation.parse((String)powerupTag.getString("PowerupLocation"));
            PowerupState state = PowerupState.valueOf(powerupTag.getString("State"));
            powerups.add(new Powerup(PowerupInstance.of(powerupLocation), state));
        }
        return new Job(player, jobInstanceLocation, level, exp, powerups);
    }

    public double getExperiencePercentage() {
        return this.experience / (double)Job.getExperienceToLevelUp(this.level) * 100.0;
    }

    public ExpCollector getExpCollector() {
        return this.expCollector;
    }

    public static class Serializer {
        public static Job fromNetwork(FriendlyByteBuf friendlyByteBuf, JobsPlayer player) {
            ResourceLocation jobInstanceLocation = friendlyByteBuf.readResourceLocation();
            int level = friendlyByteBuf.readInt();
            double experience = friendlyByteBuf.readDouble();
            int powerupCount = friendlyByteBuf.readVarInt();
            ArrayList<Powerup> powerups = new ArrayList<Powerup>();
            for (int i = 0; i < powerupCount; ++i) {
                ResourceLocation powerupLocation = friendlyByteBuf.readResourceLocation();
                PowerupState state = (PowerupState)friendlyByteBuf.readEnum(PowerupState.class);
                powerups.add(new Powerup(PowerupInstance.of(powerupLocation), state));
            }
            return new Job(player, jobInstanceLocation, level, experience, powerups);
        }

        public static void toNetwork(FriendlyByteBuf friendlyByteBuf, Job job) {
            friendlyByteBuf.writeResourceLocation(job.getJobInstance().getLocation());
            friendlyByteBuf.writeInt(job.getLevel());
            friendlyByteBuf.writeDouble(job.getExperience());
            friendlyByteBuf.writeVarInt(job.getPowerupManager().getAllPowerups().size());
            for (Powerup powerup : job.getPowerupManager().getAllPowerups()) {
                if (powerup == null || powerup.getPowerupInstance() == null) continue;
                friendlyByteBuf.writeResourceLocation(powerup.getPowerupInstance().getLocation());
                friendlyByteBuf.writeEnum((Enum)powerup.getState());
            }
        }

        public static List<Job> fromNBT(JobsServerPlayer player, CompoundTag compoundTag) {
            ListTag listTag = compoundTag.getList("Jobs", 10);
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (Tag jobTag : listTag) {
                CompoundTag jobNBT = (CompoundTag)jobTag;
                jobs.add(Job.fromNBT(player, jobNBT));
            }
            return jobs;
        }

        public static ListTag toNBT(List<Job> jobs) {
            ListTag jobsListTag = new ListTag();
            for (Job job : jobs) {
                CompoundTag jobNBT = job.toNBT();
                jobsListTag.add((Object)jobNBT);
            }
            return jobsListTag;
        }
    }
}

