/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components.conditions;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.jobs.components.SlottedItemComponent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.EmptyComponent;
import com.daqem.uilib.gui.component.text.TextComponent;
import com.daqem.uilib.gui.component.text.multiline.MultiLineTextComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ItemConditionComponent
extends EmptyComponent {
    public ItemConditionComponent(Set<ItemStack> allowedItems, Set<ItemStack> deniedItems, Supplier<ScreenRectangle> parentBounds) {
        super(0, 0, 99, 0);
        List<Object> items = new ArrayList<ItemStack>(allowedItems);
        items.removeAll(deniedItems);
        items = items.stream().collect(Collectors.toMap(ItemStack::getItem, itemStack -> itemStack, (existing, replacement) -> existing, HashMap::new)).values().stream().sorted((b1, b2) -> {
            String name1 = b1.getItem().getName().getString();
            String name2 = b2.getItem().getName().getString();
            return name1.compareToIgnoreCase(name2);
        }).toList();
        if (items.isEmpty()) {
            this.setHeight(0);
        } else if (items.size() == 1) {
            TextComponent dotText = new TextComponent(0, 0, (Component)Component.literal((String)" \u2022 "), -14806000);
            this.addComponent((IComponent)dotText);
            MultiLineTextComponent isItemTextComponent = new MultiLineTextComponent(10, 0, this.getWidth() - 10, (Component)JobsPlus.translatable("gui.jobs.condition.is", ((ItemStack)items.getFirst()).getItem().getName()), -14806000);
            this.addComponent((IComponent)isItemTextComponent);
            this.setHeight(isItemTextComponent.getHeight());
        } else {
            int columns = 4;
            int rows = (int)Math.ceil((double)items.size() / 4.0);
            int startY = 0;
            int slotSize = 24;
            for (int i = 0; i < items.size(); ++i) {
                ItemStack itemStack2 = (ItemStack)items.get(i);
                int x = i % 4 * (slotSize + 1);
                int y = startY + i / 4 * (slotSize + 1);
                this.addComponent((IComponent)new SlottedItemComponent(x, y, i, itemStack2, parentBounds));
            }
            this.setHeight(startY + rows * (slotSize + 1));
        }
    }
}

