/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.reward.rewards.job;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.data.type.JobsPlusActionDataType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.integration.arc.reward.type.JobsPlusRewardType;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class JobExpMultiplierReward
extends AbstractReward {
    private final ResourceLocation jobLocation;
    private final double multiplier;

    public JobExpMultiplierReward(double chance, int priority, ResourceLocation jobLocation, double multiplier) {
        super(chance, priority);
        this.jobLocation = jobLocation;
        this.multiplier = multiplier;
    }

    public IRewardType<?> getType() {
        return JobsPlusRewardType.JOB_EXP_MULTIPLIER;
    }

    public ActionResult apply(ActionData actionData) {
        IActionHolder sourceActionHolder = actionData.getSourceActionHolder();
        ArcPlayer player = actionData.getPlayer();
        if (player instanceof JobsServerPlayer) {
            Integer exp;
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)player;
            Job job = (Job)actionData.getData(JobsPlusActionDataType.ONLY_FOR_JOB);
            if (job == null) {
                if (sourceActionHolder instanceof JobInstance) {
                    JobInstance jobInstance = (JobInstance)sourceActionHolder;
                    if (!jobInstance.getLocation().equals((Object)this.jobLocation)) {
                        return new ActionResult();
                    }
                    job = jobsServerPlayer.jobsplus$getJob(jobInstance);
                } else if (sourceActionHolder instanceof PowerupInstance) {
                    PowerupInstance powerupInstance = (PowerupInstance)sourceActionHolder;
                    if (!powerupInstance.getJobLocation().equals((Object)this.jobLocation)) {
                        return new ActionResult();
                    }
                    job = jobsServerPlayer.jobsplus$getJob(JobInstance.of(powerupInstance.getJobLocation()));
                }
            } else if (!job.getJobInstance().getLocation().equals((Object)this.jobLocation)) {
                return new ActionResult();
            }
            if (job != null && (exp = (Integer)actionData.getData(JobsPlusActionDataType.JOB_EXP)) != null) {
                int experience = (int)((double)exp.intValue() * this.multiplier) - exp;
                job.addExperienceWithoutEvent(experience);
            }
        }
        return new ActionResult();
    }

    public Component getDescription() {
        JobInstance jobInstance = JobInstance.of(this.jobLocation);
        if (jobInstance == null) {
            return JobsPlus.literal("ERROR: Job not found: '" + this.jobLocation.toString() + "'");
        }
        return this.getDescription(new Object[]{jobInstance.getName(), this.multiplier});
    }

    public static class Serializer
    implements IRewardSerializer<JobExpMultiplierReward> {
        public JobExpMultiplierReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new JobExpMultiplierReward(chance, priority, this.getResourceLocation(jsonObject, "job"), GsonHelper.getAsDouble((JsonObject)jsonObject, (String)"multiplier"));
        }

        public JobExpMultiplierReward fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, double chance, int priority) {
            return new JobExpMultiplierReward(chance, priority, friendlyByteBuf.readResourceLocation(), friendlyByteBuf.readDouble());
        }

        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, JobExpMultiplierReward type) {
            super.toNetwork(friendlyByteBuf, (IReward)type);
            friendlyByteBuf.writeResourceLocation(type.jobLocation);
            friendlyByteBuf.writeDouble(type.multiplier);
        }
    }
}

