/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.mixin;

import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.player.ArcServerPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.ServerPlayerData;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.exp.ExpCollector;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer
extends Player
implements JobsServerPlayer {
    @Unique
    private List<Job> jobsplus$jobs = new ArrayList<Job>();
    @Unique
    private int jobsplus$coins = 0;

    public MixinServerPlayer(Level level, GameProfile gameProfile) {
        super(level, gameProfile);
    }

    @Override
    public List<Job> jobsplus$getJobs() {
        return this.jobsplus$jobs;
    }

    @Override
    public List<JobInstance> jobsplus$getJobInstances() {
        return this.jobsplus$jobs.stream().map(Job::getJobInstance).toList();
    }

    @Override
    public List<Job> jobsplus$getInactiveJobs() {
        return JobManager.getInstance().getJobs().values().stream().filter(jobInstance -> !this.jobsplus$getJobInstances().contains(jobInstance)).map(jobInstance -> new Job(this, (JobInstance)((Object)jobInstance))).toList();
    }

    @Override
    @Nullable
    public Job jobsplus$addNewJob(@NotNull JobInstance jobInstance) {
        if (jobInstance.getLocation() == null) {
            return null;
        }
        Job job = this.jobsplus$getJob(jobInstance);
        if (job == null) {
            job = new Job(this, jobInstance, 1, 0);
            this.jobsplus$jobs.add(job);
            this.jobsplus$updateJob(job);
            return job;
        }
        return null;
    }

    @Override
    public void jobsplus$removeJob(JobInstance jobInstance) {
        Job job = this.jobsplus$getJob(jobInstance);
        if (job != null) {
            this.jobsplus$jobs.remove(job);
            this.jobsplus$removeActionHolders(job);
        }
    }

    @Override
    public void jobsplus$removeActionHolders(Job job) {
        ServerPlayer serverPlayer = this.jobsplus$getServerPlayer();
        if (serverPlayer instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)serverPlayer;
            arcPlayer.arc$removeActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().forEach(powerup -> arcPlayer.arc$removeActionHolder((IActionHolder)powerup.getPowerupInstance()));
        }
    }

    @Override
    @Nullable
    public Job jobsplus$getJob(@Nullable JobInstance jobLocation) {
        if (jobLocation == null) {
            return null;
        }
        return this.jobsplus$jobs.stream().filter(job -> job.getJobInstance().getLocation().equals((Object)jobLocation.getLocation())).findFirst().orElse(null);
    }

    @Override
    public Job jobsplus$getJob(ResourceLocation jobLocation) {
        return this.jobsplus$jobs.stream().filter(job -> job.getJobInstance().getLocation().equals((Object)jobLocation)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Powerup jobsplus$getPowerup(PowerupInstance powerupInstance) {
        return this.jobsplus$getJobs().stream().map(Job::getPowerupManager).flatMap(powerupManager -> powerupManager.getAllPowerups().stream()).filter(powerup -> powerup.getPowerupInstance().getLocation().equals((Object)powerupInstance.getLocation())).findFirst().orElse(null);
    }

    @Override
    public int jobsplus$getCoins() {
        return this.jobsplus$coins;
    }

    @Override
    public void jobsplus$addCoins(int coins) {
        this.jobsplus$setCoins(Mth.clamp((int)(this.jobsplus$coins + coins), (int)0, (int)Integer.MAX_VALUE));
    }

    @Override
    public void jobsplus$setCoins(int coins) {
        this.jobsplus$coins = coins;
    }

    @Override
    public List<IActionHolder> jobsplus$getActionHolders() {
        ArrayList<JobInstance> actionHolders = new ArrayList<JobInstance>(this.jobsplus$getJobInstances());
        actionHolders.addAll(this.jobsplus$getJobs().stream().map(Job::getPowerupManager).flatMap(powerupManager -> powerupManager.getAllPowerups().stream().filter(powerup -> powerup.getState() == PowerupState.ACTIVE)).map(Powerup::getPowerupInstance).toList());
        return actionHolders;
    }

    @Override
    public ServerPlayer jobsplus$getServerPlayer() {
        return (ServerPlayer)this;
    }

    @Override
    public String jobsplus$getName() {
        return super.getName().getString();
    }

    @Override
    public void jobsplus$updateJob(Job job) {
        this.jobsplus$updateActionHolders(job);
    }

    @Override
    public void jobsplus$updateActionHolders(Job job) {
        ServerPlayer serverPlayer = this.jobsplus$getServerPlayer();
        if (serverPlayer instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)serverPlayer;
            arcPlayer.arc$removeActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().forEach(powerup -> arcPlayer.arc$removeActionHolder((IActionHolder)powerup.getPowerupInstance()));
            arcPlayer.arc$addActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().stream().filter(powerup -> powerup.getState() == PowerupState.ACTIVE).forEach(powerup -> arcPlayer.arc$addActionHolder((IActionHolder)powerup.getPowerupInstance()));
        }
    }

    @Override
    public Player jobsplus$getPlayer() {
        return this.jobsplus$getServerPlayer();
    }

    @Inject(at={@At(value="TAIL")}, method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"})
    public void restoreFrom(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof JobsServerPlayer) {
            JobsServerPlayer oldJobsServerPlayer = (JobsServerPlayer)oldPlayer;
            this.jobsplus$jobs = oldJobsServerPlayer.jobsplus$getJobs();
            this.jobsplus$coins = oldJobsServerPlayer.jobsplus$getCoins();
            this.jobsplus$jobs.forEach(job -> job.setPlayer(this));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"})
    public void addAdditionalSaveData(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.store("JobsPlus", ServerPlayerData.CODEC, (Object)new ServerPlayerData(this.jobsplus$jobs, this.jobsplus$coins));
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"})
    public void readAdditionalSaveData(ValueInput valueInput, CallbackInfo ci) {
        valueInput.read("JobsPlus", ServerPlayerData.CODEC).ifPresent(serverPlayerData -> {
            this.jobsplus$jobs = serverPlayerData.jobs().stream().filter(job -> job.getJobInstance() != null).peek(job -> job.setPlayer(this)).collect(Collectors.toCollection(ArrayList::new));
            this.jobsplus$coins = serverPlayerData.coins();
            ServerPlayer patt0$temp = this.jobsplus$getServerPlayer();
            if (patt0$temp instanceof ArcServerPlayer) {
                ArcServerPlayer arcServerPlayer = (ArcServerPlayer)patt0$temp;
                List<IActionHolder> iActionHolders = this.jobsplus$getActionHolders();
                arcServerPlayer.arc$addActionHolders(new ArrayList<IActionHolder>(iActionHolders));
            }
        });
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tickTail(CallbackInfo ci) {
        this.jobsplus$jobs.forEach(job -> {
            ExpCollector expCollector = job.getExpCollector();
            int exp = expCollector.getExp();
            if (exp > 0) {
                JobInstance jobInstance = job.getJobInstance();
                MutableComponent component = JobsPlus.translatable("job.exp.gain", exp, jobInstance.getName().getString()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)jobInstance.getColorDecimal()))).withStyle(ChatFormatting.BOLD);
                this.jobsplus$getServerPlayer().sendSystemMessage((Component)component, true);
            }
            expCollector.clear();
        });
    }
}

