/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.c2s;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.networking.s2c.ClientboundOpenJobsScreenPacket;
import com.daqem.jobsplus.player.JobsServerPlayer;
import dev.architectury.networking.NetworkManager;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ServerboundStartJobPacket
implements CustomPacketPayload {
    private final ResourceLocation jobLocation;
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundStartJobPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ServerboundStartJobPacket>(){

        @NotNull
        public ServerboundStartJobPacket decode(RegistryFriendlyByteBuf buf) {
            return new ServerboundStartJobPacket(buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ServerboundStartJobPacket packet) {
            buf.writeResourceLocation(packet.jobLocation);
        }
    };

    public ServerboundStartJobPacket(ResourceLocation jobLocation) {
        this.jobLocation = jobLocation;
    }

    public ServerboundStartJobPacket(RegistryFriendlyByteBuf friendlyByteBuf) {
        this.jobLocation = friendlyByteBuf.readResourceLocation();
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.SERVERBOUND_START_JOB;
    }

    public static void handleServerSide(ServerboundStartJobPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player instanceof JobsServerPlayer) {
            JobsServerPlayer serverPlayer = (JobsServerPlayer)player;
            JobInstance jobInstance = JobInstance.of(packet.jobLocation);
            if (jobInstance == null) {
                serverPlayer.jobsplus$getServerPlayer().sendSystemMessage((Component)JobsPlus.translatable("error.job_not_found", packet.jobLocation.toString()));
                return;
            }
            if (serverPlayer.jobsplus$getJobs().size() >= (Integer)JobsPlusConfig.maxJobs.get()) {
                serverPlayer.jobsplus$getServerPlayer().sendSystemMessage((Component)JobsPlus.translatable("error.max_jobs_reached"));
                return;
            }
            if (serverPlayer.jobsplus$getJobs().size() >= (Integer)JobsPlusConfig.amountOfFreeJobs.get()) {
                if (serverPlayer.jobsplus$getCoins() < jobInstance.getPrice()) {
                    serverPlayer.jobsplus$getServerPlayer().sendSystemMessage((Component)JobsPlus.translatable("error.not_enough_coins"));
                    return;
                }
                serverPlayer.jobsplus$setCoins(serverPlayer.jobsplus$getCoins() - jobInstance.getPrice());
            }
            serverPlayer.jobsplus$addNewJob(jobInstance);
            NetworkManager.sendToPlayer((ServerPlayer)((ServerPlayer)serverPlayer), (CustomPacketPayload)new ClientboundOpenJobsScreenPacket(Stream.concat(serverPlayer.jobsplus$getJobs().stream(), serverPlayer.jobsplus$getInactiveJobs().stream()).toList(), serverPlayer.jobsplus$getCoins()));
        }
    }
}

