/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.jobs;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.SolidColorComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.text.Text;
import com.daqem.uilib.client.gui.text.multiline.MultiLineText;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class JobInfoComponent
extends AbstractComponent<JobInfoComponent> {
    private final JobsScreenOptions options;
    private final TextComponent title;
    private final TextComponent level;
    private final TextComponent experience;
    private final TextComponent description;
    private final TextComponent wantJob;
    private Job cachedJob;

    public JobInfoComponent(int x, int y, int width, int height, JobsScreenOptions options) {
        super(null, x, y, width, height);
        this.options = options;
        this.cachedJob = this.getJob();
        class_327 font = class_310.method_1551().field_1772;
        Text titleText = new Text(font, this.getTitleText(), 4, 0);
        Text levelText = new Text(font, this.getLevelText(), 8, 18);
        Text experienceText = new Text(font, this.getExperienceText(), 70, 18);
        MultiLineText descriptionText = new MultiLineText(font, this.getDescriptionText(), 8, 32, width - 16);
        Text wantJobText = new Text(font, this.getWantJobText(), 8, 18);
        this.title = new TextComponent((IText)titleText);
        this.level = new TextComponent((IText)levelText);
        this.experience = new TextComponent((IText)experienceText);
        this.description = new TextComponent((IText)descriptionText);
        this.wantJob = new TextComponent((IText)wantJobText);
        titleText.setBold(true);
        titleText.setTextColor(this.getJob().getJobInstance().getColorDecimal());
        levelText.setTextColor(class_124.field_1063);
        experienceText.setTextColor(class_124.field_1063);
        descriptionText.setTextColor(class_124.field_1063);
        wantJobText.setTextColor(class_124.field_1063);
        this.title.setScale(2.0f);
        this.addChild((IComponent)this.title);
        this.addChild((IComponent)this.level);
        this.addChild((IComponent)this.experience);
        this.addChild((IComponent)new SolidColorComponent(7, 27, width - 14, 1, -1));
        this.addChild((IComponent)this.description);
        this.addChild((IComponent)this.wantJob);
    }

    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.cachedJob != this.options.getSelectedJob()) {
            Objects.requireNonNull(this.title.getText()).setText(this.getTitleText());
            this.title.getText().setTextColor(this.getJob().getJobInstance().getColorDecimal());
            Objects.requireNonNull(this.level.getText()).setText(this.getLevelText());
            Objects.requireNonNull(this.experience.getText()).setText(this.getExperienceText());
            Objects.requireNonNull(this.description.getText()).setText(this.getDescriptionText());
            Objects.requireNonNull(this.wantJob.getText()).setText(this.getWantJobText());
            this.cachedJob = this.getJob();
        }
    }

    private class_2561 getTitleText() {
        return this.options.getSelectedJob().getJobInstance().getName();
    }

    private class_2561 getLevelText() {
        if (this.getJob().getLevel() <= 0) {
            return JobsPlus.literal("");
        }
        return JobsPlus.translatable("gui.level", JobsPlus.literal(String.valueOf(this.getJob().getLevel())).method_27692(class_124.field_1068));
    }

    private class_2561 getExperienceText() {
        if (this.getJob().getLevel() <= 0) {
            return JobsPlus.literal("");
        }
        return JobsPlus.translatable("gui.exp", JobsPlus.literal(JobsPlus.formatNumber(this.getJob().getExperience()) + "/" + Job.getExperienceToLevelUp(this.getJob().getLevel())).method_27692(class_124.field_1068));
    }

    private class_2561 getDescriptionText() {
        return this.getJob().getJobInstance().getDescription();
    }

    private class_2561 getWantJobText() {
        if (this.getJob().getLevel() > 0) {
            return JobsPlus.literal("");
        }
        return JobsPlus.translatable("gui.want_this_job.price", JobsPlus.literal(String.valueOf(this.getJob().getJobInstance().getPrice())).method_27692(class_124.field_1068), JobsPlus.translatable("gui.price.coins").method_27692(class_124.field_1068));
    }

    private Job getJob() {
        return this.options.getSelectedJob();
    }
}

