/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.jobs;

import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.jobs.JobItemRestrictionsItemComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.scroll.ScrollOrientation;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.api.client.gui.texture.ITexture;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollBarComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollContentComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollPanelComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollWheelComponent;
import com.daqem.uilib.client.gui.text.Text;
import com.daqem.uilib.client.gui.texture.Textures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class JobItemRestrictionsComponent
extends AbstractComponent<JobItemRestrictionsComponent> {
    private static final int SCROLL_BAR_WIDTH = 12;
    private static final int SCROLL_BAR_BORDER = 1;
    private static final int SCROLL_BAR_MARGIN = 3;
    private final JobsScreenOptions options;
    private final ScrollPanelComponent scrollPanelComponent;
    private final ScrollContentComponent scrollContentComponent;
    private final ScrollBarComponent scrollBarComponent;
    private final Map<Job, List<JobItemRestrictionsItemComponent>> itemRestrictionsMap = new HashMap<Job, List<JobItemRestrictionsItemComponent>>();
    private final TextComponent noRestrictionsComponent;
    private final int scrollPanelWidth;
    private Job cachedJob = null;

    public JobItemRestrictionsComponent(int x, int y, int width, int height, JobsScreenOptions options) {
        super(null, x, y, width, height);
        this.options = options;
        class_327 font = class_310.method_1551().field_1772;
        Text noRestrictions = new Text(font, (class_2561)JobsPlus.translatable("gui.item_restriction.no_restrictions"), 0, 0);
        Text title = new Text(font, (class_2561)JobsPlus.translatable("gui.tab.right.crafting"), 7, 0);
        this.scrollPanelWidth = width - 14 - 12 - 3 - 1;
        title.setTextColor(class_124.field_1063);
        this.scrollContentComponent = new ScrollContentComponent(0, 0, 0, ScrollOrientation.VERTICAL);
        this.noRestrictionsComponent = new TextComponent(7 + this.scrollPanelWidth / 2 - noRestrictions.getWidth() / 2, this.scrollPanelWidth / 2, (IText)noRestrictions);
        TextComponent titleComponent = new TextComponent((IText)title);
        ScrollWheelComponent scrollWheelComponent = new ScrollWheelComponent(Textures.SCROLL_WHEEL, 0, 0, 12);
        this.scrollBarComponent = new ScrollBarComponent(this.scrollPanelWidth + 3 + 1, 1, 12, height - 2, ScrollOrientation.VERTICAL, scrollWheelComponent);
        Objects.requireNonNull(font);
        this.scrollPanelComponent = new ScrollPanelComponent((ITexture)Textures.SCROLL_PANE, 7, 9, this.scrollPanelWidth, height, ScrollOrientation.VERTICAL, this.scrollContentComponent, this.scrollBarComponent);
        this.addChild((IComponent)titleComponent);
        this.addChild((IComponent)this.scrollPanelComponent);
        this.addChild((IComponent)this.noRestrictionsComponent);
    }

    public void render(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.isVisible() && !this.options.getSelectedJob().equals(this.cachedJob)) {
            this.noRestrictionsComponent.setVisible(false);
            this.cachedJob = this.options.getSelectedJob();
            this.scrollContentComponent.getChildren().clear();
            if (this.itemRestrictionsMap.containsKey(this.cachedJob)) {
                List<JobItemRestrictionsItemComponent> jobItemRestrictionsItemComponents = this.itemRestrictionsMap.get(this.cachedJob);
                if (jobItemRestrictionsItemComponents.isEmpty()) {
                    this.noRestrictionsComponent.setVisible(true);
                } else {
                    this.scrollContentComponent.addChildren(new ArrayList<JobItemRestrictionsItemComponent>(jobItemRestrictionsItemComponents));
                }
            } else {
                Map<ItemRestriction, Integer> itemRestrictions = this.cachedJob.getJobInstance().getItemRestrictions();
                ArrayList<JobItemRestrictionsItemComponent> components = new ArrayList<JobItemRestrictionsItemComponent>();
                for (Map.Entry<ItemRestriction, Integer> entry : itemRestrictions.entrySet()) {
                    ItemRestriction itemRestriction = entry.getKey();
                    int requiredLevel = entry.getValue();
                    components.add(new JobItemRestrictionsItemComponent(0, 0, this.scrollPanelWidth, 24, this.cachedJob, itemRestriction, requiredLevel));
                }
                if (components.isEmpty()) {
                    this.noRestrictionsComponent.setVisible(true);
                } else {
                    components.sort((o1, o2) -> {
                        int level1 = o1.getRequiredLevel();
                        int level2 = o2.getRequiredLevel();
                        return Integer.compare(level1, level2);
                    });
                    this.itemRestrictionsMap.put(this.cachedJob, components);
                    this.scrollContentComponent.addChildren(new ArrayList(components));
                }
            }
        }
    }

    public void resetScroll() {
        this.scrollContentComponent.scroll(this.scrollPanelComponent, (double)this.scrollPanelComponent.getTotalX(), (double)this.scrollPanelComponent.getTotalY());
        this.scrollBarComponent.scroll(this.scrollPanelComponent, (double)this.scrollPanelComponent.getTotalX(), (double)this.scrollPanelComponent.getTotalY());
    }
}

