/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.command;

import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.command.arguments.EnumArgument;
import com.daqem.jobsplus.command.arguments.JobArgument;
import com.daqem.jobsplus.command.arguments.PowerupArgument;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class JobCommand {
    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"job").requires(commandSourceStack -> commandSourceStack.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9244((String)"target_player", (ArgumentType)class_2186.method_9305()).executes(context -> JobCommand.debug((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"target_player"))))).executes(context -> JobCommand.debug((class_2168)context.getSource(), ((class_2168)context.getSource()).method_44023())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"level").then(class_2170.method_9244((String)"target_player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"job", (ArgumentType)JobArgument.job()).then(class_2170.method_9244((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> JobCommand.setLevel((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))))).then(class_2170.method_9247((String)"experience").then(class_2170.method_9244((String)"target_player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"job", (ArgumentType)JobArgument.job()).then(class_2170.method_9244((String)"experience", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)Float.MAX_VALUE)).executes(context -> JobCommand.setExperience((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"), FloatArgumentType.getFloat((CommandContext)context, (String)"experience")))))))).then(class_2170.method_9247((String)"coins").then(class_2170.method_9244((String)"target_player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"coins", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)Float.MAX_VALUE)).executes(context -> JobCommand.setCoins((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"target_player"), FloatArgumentType.getFloat((CommandContext)context, (String)"coins"))))))).then(class_2170.method_9247((String)"powerup").then(class_2170.method_9244((String)"target_player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"job", (ArgumentType)JobArgument.job()).then(class_2170.method_9244((String)"powerup", (ArgumentType)PowerupArgument.powerup()).then(class_2170.method_9244((String)"powerup_state", EnumArgument.enumArgument(PowerupState.class)).executes(context -> JobCommand.setPowerup((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"), PowerupArgument.getPowerup(context, "powerup"), (PowerupState)((Object)((Object)context.getArgument("powerup_state", PowerupState.class)))))))).then(class_2170.method_9247((String)"clear").executes(context -> JobCommand.clearPowerups((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"))))))))).then(class_2170.method_9247((String)"itemtag").executes(context -> {
            class_3222 serverPlayer = ((class_2168)context.getSource()).method_44023();
            if (serverPlayer != null) {
                serverPlayer.method_43496((class_2561)JobsPlus.literal(serverPlayer.method_6047().method_40133().map(itemTagKey -> itemTagKey.comp_327().toString()).collect(Collectors.joining(", "))));
            }
            return 0;
        }))).then(class_2170.method_9247((String)"attributes").executes(context -> {
            class_3222 serverPlayer = ((class_2168)context.getSource()).method_44023();
            if (serverPlayer != null) {
                serverPlayer.method_6127().method_26851().forEach(attribute -> {
                    serverPlayer.method_43496((class_2561)JobsPlus.literal(attribute.method_6198().method_55840() + ": " + attribute.method_6194()));
                    attribute.method_6195().forEach(attributeModifier -> serverPlayer.method_43496((class_2561)JobsPlus.literal(String.valueOf(attributeModifier.comp_2447()) + ": " + attributeModifier.comp_2449())));
                    serverPlayer.method_43496((class_2561)JobsPlus.literal(" "));
                });
            }
            return 0;
        })));
    }

    private static int clearPowerups(class_2168 source, class_3222 targetPlayer, JobInstance jobInstance) {
        JobsServerPlayer jobsServerPlayer;
        Job job;
        if (targetPlayer instanceof JobsServerPlayer && (job = (jobsServerPlayer = (JobsServerPlayer)targetPlayer).jobsplus$getJob(jobInstance)) != null) {
            job.getPowerupManager().clearPowerups();
            jobsServerPlayer.jobsplus$updateJob(job);
            source.method_9226(() -> JobsPlus.translatable("command.set.powerup.success_clear", jobInstance.getName()), false);
        }
        return 0;
    }

    private static int debug(class_2168 source, class_3222 target) {
        if (target instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)target;
            arcPlayer.arc$getActionHolders().forEach(actionHolder -> {
                source.method_9226(() -> class_2561.method_43470((String)actionHolder.getLocation().toString()), false);
                source.method_9226(() -> class_2561.method_43470((String)("actions: " + actionHolder.getActions().size())), false);
                source.method_9226(() -> class_2561.method_43470((String)" "), false);
            });
        }
        return 0;
    }

    private static int setPowerup(class_2168 source, class_3222 target, JobInstance jobInstance, PowerupInstance powerupInstance, PowerupState powerupState) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            Job job = jobsServerPlayer.jobsplus$getJob(jobInstance);
            job.getPowerupManager().forceAddPowerup(jobsServerPlayer, job, powerupInstance, powerupState);
            source.method_9226(() -> JobsPlus.translatable("command.set.powerup.success", powerupInstance.getName(), jobInstance.getName(), powerupState.toString()), false);
        }
        return 1;
    }

    private static int setCoins(class_2168 source, class_3222 target, double coins) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            jobsServerPlayer.jobsplus$setCoins(coins);
            source.method_9226(() -> JobsPlus.translatable("command.set.coins.success", JobsPlus.formatNumber(coins), jobsServerPlayer.jobsplus$getName()), false);
        }
        return 0;
    }

    private static int setExperience(class_2168 source, class_3222 target, JobInstance jobInstance, double experience) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            Job job = jobsServerPlayer.jobsplus$getJob(jobInstance);
            if (job != null) {
                int maxExperienceForLevel = Job.getExperienceToLevelUp(job.getLevel());
                if (experience >= (double)maxExperienceForLevel) {
                    source.method_9213((class_2561)JobsPlus.translatable("command.set.experience.experience_too_high", maxExperienceForLevel));
                    return 0;
                }
                if (job.getLevel() >= jobInstance.getMaxLevel()) {
                    source.method_9213((class_2561)JobsPlus.translatable("command.set.experience.already_max_level"));
                }
                job.setExperience(experience, false);
                source.method_9226(() -> JobsPlus.translatable("command.set.experience.success", jobInstance.getName(), JobsPlus.formatNumber(experience), jobsServerPlayer.jobsplus$getPlayer().method_5476()), false);
            } else {
                source.method_9213((class_2561)JobsPlus.translatable("command.does_not_have_job", jobsServerPlayer.jobsplus$getPlayer().method_5476(), jobInstance.getName()));
            }
        }
        return 0;
    }

    private static int setLevel(class_2168 source, class_3222 target, JobInstance jobInstance, int level) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            Job job = jobsServerPlayer.jobsplus$getJob(jobInstance);
            if (level == 0) {
                if (job != null) {
                    jobsServerPlayer.jobsplus$removeJob(jobInstance);
                    source.method_9226(() -> JobsPlus.translatable("command.set.level.removed_job", jobInstance.getName(), jobsServerPlayer.jobsplus$getPlayer().method_5476()), false);
                } else {
                    source.method_9213((class_2561)JobsPlus.translatable("command.set.level.does_not_have_job"));
                }
                return 0;
            }
            if (level > jobInstance.getMaxLevel()) {
                source.method_9213((class_2561)JobsPlus.translatable("command.set.level.cannot_be_higher_than_max", jobInstance.getMaxLevel()));
                return 0;
            }
            if (job != null) {
                job.setLevel(level);
                source.method_9226(() -> JobsPlus.translatable("command.set.level.success", jobInstance.getName(), level, jobsServerPlayer.jobsplus$getPlayer().method_5476()), false);
            } else {
                job = jobsServerPlayer.jobsplus$addNewJob(jobInstance);
                if (job != null) {
                    job.setLevel(level);
                    source.method_9226(() -> JobsPlus.translatable("command.set.level.success_new_job", jobInstance.getName(), level, jobsServerPlayer.jobsplus$getPlayer().method_5476()), false);
                } else {
                    source.method_9213((class_2561)JobsPlus.translatable("command.set.level.cannot_add_job"));
                }
            }
        } else {
            source.method_9213((class_2561)JobsPlus.translatable("command.set.level.invalid_target"));
        }
        return 0;
    }
}

