/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.condition.conditions.powerup;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.type.JobsPlusConditionType;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.google.gson.JsonObject;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class HasPowerupActivatedCondition
extends AbstractCondition {
    private final class_2960 powerupLocation;

    public HasPowerupActivatedCondition(boolean inverted, class_2960 powerupLocation) {
        super(inverted);
        this.powerupLocation = powerupLocation;
    }

    public IConditionType<? extends ICondition> getType() {
        return JobsPlusConditionType.HAS_POWERUP_ACTIVATED;
    }

    public boolean isMet(ActionData actionData) {
        PowerupInstance powerupInstance = PowerupInstance.of(this.powerupLocation);
        if (powerupInstance != null) {
            ArcPlayer arcPlayer;
            if (powerupInstance.getLocation().equals((Object)this.powerupLocation) && (arcPlayer = actionData.getPlayer()) instanceof JobsServerPlayer) {
                JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)arcPlayer;
                Powerup powerup = jobsServerPlayer.jobsplus$getPowerup(powerupInstance);
                return powerup != null && powerup.getState() == PowerupState.ACTIVE;
            }
        } else {
            JobsPlus.LOGGER.error("Powerup " + String.valueOf(this.powerupLocation) + " does not exist! Trying to use it in the condition has_powerup_activated.");
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<HasPowerupActivatedCondition> {
        public HasPowerupActivatedCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new HasPowerupActivatedCondition(inverted, this.getResourceLocation(jsonObject, "powerup"));
        }

        public HasPowerupActivatedCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new HasPowerupActivatedCondition(inverted, friendlyByteBuf.method_10810());
        }

        public void toNetwork(class_9129 friendlyByteBuf, HasPowerupActivatedCondition type) {
            super.toNetwork(friendlyByteBuf, (ICondition)type);
            friendlyByteBuf.method_10812(type.powerupLocation);
        }
    }
}

