/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.powerup;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.jobsplus.JobsPlusExpectPlatform;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class PowerupManager
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(PowerupInstance.class, (Object)new PowerupInstance.Serializer()).create();
    private static final Logger LOGGER = LogUtils.getLogger();
    protected ImmutableMap<class_2960, PowerupInstance> powerups = ImmutableMap.of();
    private static PowerupManager instance;

    public PowerupManager() {
        super(GSON, "jobsplus/powerups");
        instance = this;
    }

    protected void apply(@NotNull Map<class_2960, JsonElement> map, @NotNull class_3300 resourceManager, @NotNull class_3695 profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActionHoldersForType(JobsPlusActionHolderType.POWERUP_INSTANCE);
        ArrayList tempPowerups = new ArrayList();
        map.forEach((location, jsonElement) -> {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                jsonObject.addProperty("location", location.toString());
                PowerupInstance powerup = (PowerupInstance)((Object)((Object)GSON.fromJson((JsonElement)jsonObject, PowerupInstance.class)));
                tempPowerups.add(powerup);
            }
            catch (Exception e) {
                LOGGER.error("Could not deserialize job {} because: {}", location, (Object)e.getMessage());
                throw e;
            }
        });
        LOGGER.info("Loaded {} job powerups", (Object)tempPowerups.size());
        actionHolderManager.registerActionHolders(new ArrayList(tempPowerups));
    }

    public static PowerupManager getInstance() {
        return instance != null ? instance : JobsPlusExpectPlatform.getPowerupManager();
    }

    public ImmutableMap<class_2960, PowerupInstance> getRootPowerups() {
        return (ImmutableMap)this.getAllPowerups().entrySet().stream().filter(entry -> ((PowerupInstance)((Object)((Object)entry.getValue()))).getParentLocation() == null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<class_2960, PowerupInstance> getAllPowerups() {
        return (Map)ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> actionHolder instanceof PowerupInstance).map(actionHolder -> (PowerupInstance)((Object)actionHolder)).collect(ImmutableMap.toImmutableMap(AbstractActionHolder::getLocation, powerupInstance -> powerupInstance));
    }
}

