/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.reward.rewards.job;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.reward.type.JobsPlusRewardType;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class JobExpReward
extends AbstractReward {
    private final int min;
    private final int max;

    public JobExpReward(double chance, int priority, int min, int max) {
        super(chance, priority);
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max for JobExpActionReward.");
        }
    }

    public IRewardType<?> getType() {
        return JobsPlusRewardType.JOB_EXP;
    }

    public ActionResult apply(ActionData actionData) {
        IActionHolder iActionHolder = actionData.getSourceActionHolder();
        if (iActionHolder instanceof JobInstance) {
            JobsServerPlayer jobsServerPlayer;
            Job job;
            JobInstance jobInstance = (JobInstance)iActionHolder;
            ArcPlayer arcPlayer = actionData.getPlayer();
            if (arcPlayer instanceof JobsServerPlayer && (job = (jobsServerPlayer = (JobsServerPlayer)arcPlayer).jobsplus$getJob(jobInstance)) != null) {
                double exp = (double)this.min + actionData.getPlayer().arc$getPlayer().method_59922().method_43058() * (double)(this.max - this.min);
                job.addExperience(exp);
            }
        }
        return new ActionResult();
    }

    public class_2561 getDescription() {
        return this.getDescription(new Object[]{this.min, this.max});
    }

    public static class Serializer
    implements IRewardSerializer<JobExpReward> {
        public JobExpReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new JobExpReward(chance, priority, class_3518.method_15260((JsonObject)jsonObject, (String)"min"), class_3518.method_15260((JsonObject)jsonObject, (String)"max"));
        }

        public JobExpReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new JobExpReward(chance, priority, friendlyByteBuf.readInt(), friendlyByteBuf.readInt());
        }

        public void toNetwork(class_9129 friendlyByteBuf, JobExpReward type) {
            super.toNetwork(friendlyByteBuf, (IReward)type);
            friendlyByteBuf.method_53002(type.min);
            friendlyByteBuf.method_53002(type.max);
        }
    }
}

