/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.c2s;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.networking.s2c.ClientboundOpenJobsScreenPacket;
import com.daqem.jobsplus.player.JobsServerPlayer;
import dev.architectury.networking.NetworkManager;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class ServerboundStartJobPacket
implements class_8710 {
    private final class_2960 jobLocation;
    public static final class_9139<class_9129, ServerboundStartJobPacket> STREAM_CODEC = new class_9139<class_9129, ServerboundStartJobPacket>(){

        @NotNull
        public ServerboundStartJobPacket decode(class_9129 buf) {
            return new ServerboundStartJobPacket(buf);
        }

        public void encode(class_9129 buf, ServerboundStartJobPacket packet) {
            buf.method_10812(packet.jobLocation);
        }
    };

    public ServerboundStartJobPacket(class_2960 jobLocation) {
        this.jobLocation = jobLocation;
    }

    public ServerboundStartJobPacket(class_9129 friendlyByteBuf) {
        this.jobLocation = friendlyByteBuf.method_10810();
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return JobsPlusNetworking.SERVERBOUND_START_JOB;
    }

    public static void handleServerSide(ServerboundStartJobPacket packet, NetworkManager.PacketContext context) {
        class_1657 class_16572 = context.getPlayer();
        if (class_16572 instanceof JobsServerPlayer) {
            JobsServerPlayer serverPlayer = (JobsServerPlayer)class_16572;
            JobInstance jobInstance = JobInstance.of(packet.jobLocation);
            if (jobInstance == null) {
                context.getPlayer().method_43496((class_2561)JobsPlus.translatable("error.job_not_found", packet.jobLocation.toString()));
                return;
            }
            if (serverPlayer.jobsplus$getJobs().size() >= (Integer)JobsPlusConfig.maxJobs.get()) {
                context.getPlayer().method_43496((class_2561)JobsPlus.translatable("error.max_jobs_reached"));
                return;
            }
            if (serverPlayer.jobsplus$getJobs().size() >= (Integer)JobsPlusConfig.amountOfFreeJobs.get()) {
                if (serverPlayer.jobsplus$getCoins() < (double)jobInstance.getPrice()) {
                    context.getPlayer().method_43496((class_2561)JobsPlus.translatable("error.not_enough_coins"));
                    return;
                }
                serverPlayer.jobsplus$setCoins(serverPlayer.jobsplus$getCoins() - (double)jobInstance.getPrice());
            }
            serverPlayer.jobsplus$addNewJob(jobInstance);
            NetworkManager.sendToPlayer((class_3222)((class_3222)serverPlayer), (class_8710)new ClientboundOpenJobsScreenPacket(Stream.concat(serverPlayer.jobsplus$getJobs().stream(), serverPlayer.jobsplus$getInactiveJobs().stream()).toList(), serverPlayer.jobsplus$getCoins()));
        }
    }
}

