/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.c2s;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerboundStartPowerupPacket
implements class_8710 {
    @Nullable
    private final JobInstance jobInstance;
    @Nullable
    private final PowerupInstance powerupInstance;
    public static final class_9139<class_9129, ServerboundStartPowerupPacket> STREAM_CODEC = new class_9139<class_9129, ServerboundStartPowerupPacket>(){

        @NotNull
        public ServerboundStartPowerupPacket decode(class_9129 buf) {
            return new ServerboundStartPowerupPacket(buf);
        }

        public void encode(class_9129 buf, ServerboundStartPowerupPacket packet) {
            boolean jobInstanceIsNotNull = packet.jobInstance != null;
            buf.method_52964(jobInstanceIsNotNull);
            if (jobInstanceIsNotNull) {
                buf.method_10812(packet.jobInstance.getLocation());
            }
            boolean powerupInstanceIsNotNull = packet.powerupInstance != null;
            buf.method_52964(powerupInstanceIsNotNull);
            if (powerupInstanceIsNotNull) {
                buf.method_10812(packet.powerupInstance.getLocation());
            }
        }
    };

    public ServerboundStartPowerupPacket(@Nullable JobInstance jobInstance, @Nullable PowerupInstance powerupInstance) {
        this.jobInstance = jobInstance;
        this.powerupInstance = powerupInstance;
    }

    public ServerboundStartPowerupPacket(class_9129 friendlyByteBuf) {
        boolean jobInstanceIsNotNull = friendlyByteBuf.readBoolean();
        this.jobInstance = jobInstanceIsNotNull ? JobInstance.of(friendlyByteBuf.method_10810()) : null;
        boolean powerupInstanceIsNotNull = friendlyByteBuf.readBoolean();
        this.powerupInstance = powerupInstanceIsNotNull ? PowerupInstance.of(friendlyByteBuf.method_10810()) : null;
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return JobsPlusNetworking.SERVERBOUND_START_POWERUP;
    }

    public static void handleServerSide(ServerboundStartPowerupPacket packet, NetworkManager.PacketContext context) {
        if (packet.jobInstance == null || packet.powerupInstance == null) {
            return;
        }
        class_1657 class_16572 = context.getPlayer();
        if (class_16572 instanceof JobsServerPlayer) {
            JobsServerPlayer serverPlayer = (JobsServerPlayer)class_16572;
            Job job = serverPlayer.jobsplus$getJob(packet.jobInstance);
            if (job == null) {
                context.getPlayer().method_43496((class_2561)JobsPlus.translatable("error.job_not_found", packet.jobInstance.getLocation().toString()));
                return;
            }
            if (serverPlayer.jobsplus$getCoins() < (double)packet.powerupInstance.getPrice()) {
                context.getPlayer().method_43496((class_2561)JobsPlus.translatable("error.not_enough_coins"));
                return;
            }
            if (job.getLevel() < packet.powerupInstance.getRequiredLevel()) {
                context.getPlayer().method_43496((class_2561)JobsPlus.translatable("error.not_high_enough_level"));
                return;
            }
            serverPlayer.jobsplus$setCoins(serverPlayer.jobsplus$getCoins() - (double)packet.powerupInstance.getPrice());
            job.getPowerupManager().addPowerup(serverPlayer, job, packet.powerupInstance);
        }
    }
}

