/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.player.job;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.event.triggers.JobEvents;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.sync.job.ClientboundUpdateJobPacket;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.exp.ExpCollector;
import com.daqem.jobsplus.player.job.powerup.JobPowerupManager;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class Job {
    private final JobInstance jobInstance;
    private final JobPowerupManager powerupManager;
    private JobsPlayer player;
    private int level;
    private double experience;
    private final ExpCollector expCollector = new ExpCollector();

    public Job(JobsPlayer player, JobInstance jobInstance) {
        this(player, jobInstance, 0, 0.0, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, double experience) {
        this(player, jobInstance, level, experience, new ArrayList<Powerup>());
    }

    public Job(JobsPlayer player, class_2960 jobInstanceLocation, int level, double experience, @NotNull List<Powerup> powerups) {
        this(player, JobManager.getInstance().getJobs().get(jobInstanceLocation), level, experience, powerups);
    }

    public Job(JobsPlayer player, JobInstance jobInstance, int level, double experience, @NotNull List<Powerup> powerups) {
        this.player = player;
        this.jobInstance = jobInstance;
        this.powerupManager = new JobPowerupManager(powerups);
        this.level = level;
        this.experience = experience;
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public JobPowerupManager getPowerupManager() {
        return this.powerupManager;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.syncWithClient();
    }

    public double getExperience() {
        return this.experience;
    }

    public void setExperience(double experience, boolean triggerEvent) {
        double change = experience - this.experience;
        if (!((Boolean)JobsPlusConfig.useDecimalValuesForXP.get()).booleanValue()) {
            change = Math.floor(change);
            experience = Math.floor(experience);
        }
        this.expCollector.addExp(change);
        this.experience = experience;
        this.checkForLevelUp();
        this.syncWithClient();
        if (triggerEvent) {
            JobEvents.onJobExperience(this.player, this, change);
        }
    }

    public void addExperience(double experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience * (Double)JobsPlusConfig.xpMultiplier.get(), true);
    }

    public void addExperienceWithoutEvent(double experience) {
        JobsPlus.debug("Adding {} experience to {}'s {} job without event.", experience, this.player.jobsplus$getName(), this.jobInstance.getName().getString());
        this.setExperience(this.getExperience() + experience * (Double)JobsPlusConfig.xpMultiplier.get(), false);
    }

    private void checkForLevelUp() {
        int experienceToLevelUp = Job.getExperienceToLevelUp(this.level);
        if (this.experience >= (double)experienceToLevelUp) {
            this.setLevel(this.level + 1);
            this.setExperience(this.experience - (double)experienceToLevelUp, false);
            JobEvents.onJobLevelUp(this.player, this);
            JobsPlayer jobsPlayer = this.player;
            if (jobsPlayer instanceof JobsServerPlayer) {
                JobsServerPlayer serverPlayer = (JobsServerPlayer)jobsPlayer;
                serverPlayer.jobsplus$updateJobOnClient(this);
            }
        }
    }

    private void syncWithClient() {
        JobsPlayer jobsPlayer = this.player;
        if (jobsPlayer instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)jobsPlayer;
            NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_8710)new ClientboundUpdateJobPacket(this));
        }
    }

    public static int getExperienceToLevelUp(int level) {
        if (level == 0) {
            return 0;
        }
        return (int)(100.0 + (double)(level * level) * 0.5791);
    }

    public void setPlayer(JobsPlayer player) {
        this.player = player;
    }

    public class_2487 toNBT() {
        class_2487 jobTag = new class_2487();
        jobTag.method_10582("JobInstanceLocation", this.getJobInstance().getLocation().toString());
        jobTag.method_10569("Level", this.getLevel());
        jobTag.method_10549("Experience", this.getExperience());
        class_2499 powerupsTag = new class_2499();
        for (Powerup powerup : this.powerupManager.getAllPowerups()) {
            class_2487 powerupTag = new class_2487();
            powerupTag.method_10582("PowerupLocation", powerup.getPowerupInstance().getLocation().toString());
            powerupTag.method_10582("State", powerup.getState().name());
            powerupsTag.add((Object)powerupTag);
        }
        jobTag.method_10566("Powerups", (class_2520)powerupsTag);
        return jobTag;
    }

    public static Job fromNBT(JobsPlayer player, class_2487 tag) {
        class_2960 jobInstanceLocation = class_2960.method_60654((String)tag.method_10558("JobInstanceLocation"));
        int level = tag.method_10550("Level");
        double exp = tag.method_10574("Experience");
        class_2499 powerupsTag = tag.method_10554("Powerups", 10);
        ArrayList<Powerup> powerups = new ArrayList<Powerup>();
        for (int i = 0; i < powerupsTag.size(); ++i) {
            class_2487 powerupTag = powerupsTag.method_10602(i);
            class_2960 powerupLocation = class_2960.method_60654((String)powerupTag.method_10558("PowerupLocation"));
            PowerupState state = PowerupState.valueOf(powerupTag.method_10558("State"));
            powerups.add(new Powerup(PowerupInstance.of(powerupLocation), state));
        }
        return new Job(player, jobInstanceLocation, level, exp, powerups);
    }

    public double getExperiencePercentage() {
        return this.experience / (double)Job.getExperienceToLevelUp(this.level) * 100.0;
    }

    public ExpCollector getExpCollector() {
        return this.expCollector;
    }

    public static class Serializer {
        public static Job fromNetwork(class_2540 friendlyByteBuf, JobsPlayer player) {
            class_2960 jobInstanceLocation = friendlyByteBuf.method_10810();
            int level = friendlyByteBuf.readInt();
            double experience = friendlyByteBuf.readDouble();
            int powerupCount = friendlyByteBuf.method_10816();
            ArrayList<Powerup> powerups = new ArrayList<Powerup>();
            for (int i = 0; i < powerupCount; ++i) {
                class_2960 powerupLocation = friendlyByteBuf.method_10810();
                PowerupState state = (PowerupState)friendlyByteBuf.method_10818(PowerupState.class);
                powerups.add(new Powerup(PowerupInstance.of(powerupLocation), state));
            }
            return new Job(player, jobInstanceLocation, level, experience, powerups);
        }

        public static void toNetwork(class_2540 friendlyByteBuf, Job job) {
            friendlyByteBuf.method_10812(job.getJobInstance().getLocation());
            friendlyByteBuf.method_53002(job.getLevel());
            friendlyByteBuf.method_52940(job.getExperience());
            friendlyByteBuf.method_10804(job.getPowerupManager().getAllPowerups().size());
            for (Powerup powerup : job.getPowerupManager().getAllPowerups()) {
                friendlyByteBuf.method_10812(powerup.getPowerupInstance().getLocation());
                friendlyByteBuf.method_10817((Enum)powerup.getState());
            }
        }

        public static List<Job> fromNBT(JobsServerPlayer player, class_2487 compoundTag) {
            class_2499 listTag = compoundTag.method_10554("Jobs", 10);
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (class_2520 jobTag : listTag) {
                class_2487 jobNBT = (class_2487)jobTag;
                jobs.add(Job.fromNBT(player, jobNBT));
            }
            return jobs;
        }

        public static class_2499 toNBT(List<Job> jobs) {
            class_2499 jobsListTag = new class_2499();
            for (Job job : jobs) {
                class_2487 jobNBT = job.toNBT();
                jobsListTag.add((Object)jobNBT);
            }
            return jobsListTag;
        }
    }
}

