/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components;

import com.daqem.arc.api.action.data.ActionDataBuilder;
import com.daqem.arc.api.action.data.type.ActionDataType;
import com.daqem.arc.api.action.type.ActionType;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.data.condition.NotCondition;
import com.daqem.arc.data.condition.OrCondition;
import com.daqem.arc.data.condition.block.BlockCondition;
import com.daqem.arc.data.condition.block.BlocksCondition;
import com.daqem.arc.data.condition.block.NotInBlockPosCacheCondition;
import com.daqem.arc.data.condition.block.ore.IsOreCondition;
import com.daqem.arc.data.condition.block.properties.BlockHardnessCondition;
import com.daqem.arc.data.condition.item.ItemCondition;
import com.daqem.arc.data.condition.item.ItemsCondition;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.BlockConditionComponent;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.DefaultConditionComponent;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.ItemConditionComponent;
import com.daqem.jobsplus.client.gui.jobs.components.conditions.NotConditionComponent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.EmptyComponent;
import com.daqem.uilib.gui.component.text.TruncatedTextComponent;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import net.minecraft.class_8030;

public class ConditionsComponent
extends EmptyComponent {
    private static List<class_2248> ORE_BLOCKS = null;

    public ConditionsComponent(List<ICondition> conditions, Supplier<class_8030> parentBounds) {
        super(0, 0, 99, 9);
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (conditions.isEmpty()) {
            TruncatedTextComponent noConditionsText = new TruncatedTextComponent(0, 2, this.method_25368(), (class_2561)JobsPlus.translatable("gui.jobs.no_conditions"), -14806000);
            this.addComponent((IComponent)noConditionsText);
            this.setHeight(noConditionsText.method_25364());
        } else {
            TruncatedTextComponent title = new TruncatedTextComponent(0, 2, this.method_25368(), (class_2561)JobsPlus.translatable("gui.jobs.conditions").method_27694(style -> style.method_30938(Boolean.valueOf(true))), -14806000);
            this.addComponent((IComponent)title);
            int yOffset = title.method_25364() + 4;
            HashSet<Object> parsedConditions = new HashSet<Object>();
            List<NotCondition> notConditions = this.getNotConditions(conditions);
            conditions = conditions.stream().sorted(Comparator.comparing(x -> {
                if (x instanceof NotCondition) {
                    return 3;
                }
                if (x instanceof OrCondition) {
                    return 2;
                }
                if (x instanceof BlockCondition || x instanceof BlocksCondition || x instanceof ItemCondition || x instanceof ItemsCondition) {
                    return 0;
                }
                return 1;
            })).toList();
            for (ICondition condition : conditions) {
                Object blockConditionComponent;
                float hardness;
                BlocksCondition nbcs;
                BlockCondition nbc;
                Object bcs;
                BlockCondition bc;
                HashSet<class_2248> deniedBlocks;
                HashSet<Object> allowedBlocks;
                List<ICondition> notBlockConditions;
                if (parsedConditions.contains(condition)) continue;
                if (condition instanceof NotInBlockPosCacheCondition || condition instanceof OrCondition) {
                    parsedConditions.add(condition);
                    continue;
                }
                if (condition instanceof NotCondition) continue;
                if (condition instanceof BlockCondition || condition instanceof BlocksCondition) {
                    List<ICondition> blockConditions = conditions.stream().filter(c -> c instanceof BlockCondition || c instanceof BlocksCondition || c instanceof BlockHardnessCondition).toList();
                    notBlockConditions = notConditions.stream().map(NotCondition::getConditions).flatMap(Collection::stream).filter(c -> c instanceof BlockCondition || c instanceof BlocksCondition || c instanceof BlockHardnessCondition || c instanceof IsOreCondition).toList();
                    allowedBlocks = new HashSet();
                    deniedBlocks = new HashSet<class_2248>();
                    for (ICondition blockCondition : blockConditions) {
                        if (blockCondition instanceof BlockCondition) {
                            bc = (BlockCondition)blockCondition;
                            allowedBlocks.add(bc.getBlock());
                            parsedConditions.add(blockCondition);
                            continue;
                        }
                        if (!(blockCondition instanceof BlocksCondition)) continue;
                        bcs = (BlocksCondition)blockCondition;
                        allowedBlocks.addAll(bcs.getAllBlocks(level.method_30349()));
                        parsedConditions.add(blockCondition);
                    }
                    for (ICondition blockCondition : blockConditions) {
                        if (!(blockCondition instanceof BlockHardnessCondition)) continue;
                        BlockHardnessCondition bhc2 = (BlockHardnessCondition)blockCondition;
                        for (class_2248 class_22482 : allowedBlocks) {
                            float hardness2 = class_22482.method_9564().method_26214((class_1922)Objects.requireNonNull(level), class_2338.field_10980);
                            if (bhc2.getMin() > hardness2) {
                                deniedBlocks.add(class_22482);
                            }
                            if (!(bhc2.getMax() < hardness2)) continue;
                            deniedBlocks.add(class_22482);
                        }
                        parsedConditions.add(blockCondition);
                    }
                    for (ICondition notBlockCondition : notBlockConditions) {
                        if (notBlockCondition instanceof BlockCondition) {
                            nbc = (BlockCondition)notBlockCondition;
                            deniedBlocks.add(nbc.getBlock());
                            parsedConditions.add(notBlockCondition);
                            continue;
                        }
                        if (notBlockCondition instanceof BlocksCondition) {
                            nbcs = (BlocksCondition)notBlockCondition;
                            deniedBlocks.addAll(nbcs.getAllBlocks(level.method_30349()));
                            parsedConditions.add(notBlockCondition);
                            continue;
                        }
                        if (notBlockCondition instanceof BlockHardnessCondition) {
                            BlockHardnessCondition blockHardnessCondition = (BlockHardnessCondition)notBlockCondition;
                            for (class_2248 class_22483 : allowedBlocks) {
                                hardness = class_22483.method_9564().method_26214((class_1922)Objects.requireNonNull(level), class_2338.field_10980);
                                if (blockHardnessCondition.getMin() > hardness) {
                                    deniedBlocks.add(class_22483);
                                }
                                if (!(blockHardnessCondition.getMax() < hardness)) continue;
                                deniedBlocks.add(class_22483);
                            }
                            parsedConditions.add(notBlockCondition);
                            continue;
                        }
                        if (!(notBlockCondition instanceof IsOreCondition)) continue;
                        for (class_2248 class_22484 : allowedBlocks) {
                            if (!this.getOreBlocks().contains(class_22484)) continue;
                            deniedBlocks.add(class_22484);
                        }
                        parsedConditions.add(notBlockCondition);
                    }
                    blockConditionComponent = new BlockConditionComponent(allowedBlocks, deniedBlocks, parentBounds);
                    blockConditionComponent.method_46419(yOffset);
                    this.addComponent((IComponent)blockConditionComponent);
                    yOffset += blockConditionComponent.method_25364();
                    continue;
                }
                if (condition instanceof BlockHardnessCondition) {
                    BlockHardnessCondition hardnessCondition = (BlockHardnessCondition)condition;
                    if (parsedConditions.contains(hardnessCondition)) continue;
                    if (conditions.stream().noneMatch(b -> b instanceof BlockCondition || b instanceof BlocksCondition)) {
                        Set allowedBlocks2 = level.method_30349().method_30530(class_7924.field_41254).method_10220().filter(block -> {
                            float hardness = block.method_9564().method_26214((class_1922)Objects.requireNonNull(level), class_2338.field_10980);
                            return hardnessCondition.getMin() <= hardness && hardness <= hardnessCondition.getMax();
                        }).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
                        BlockConditionComponent hardnessConditionComponent = new BlockConditionComponent(allowedBlocks2, new HashSet<class_2248>(), parentBounds);
                        hardnessConditionComponent.method_46419(yOffset);
                        this.addComponent((IComponent)hardnessConditionComponent);
                        yOffset += hardnessConditionComponent.method_25364();
                        parsedConditions.add(hardnessCondition);
                        continue;
                    }
                }
                if (condition instanceof IsOreCondition) {
                    IsOreCondition isOreCondition = (IsOreCondition)condition;
                    if (parsedConditions.contains(isOreCondition)) continue;
                    if (conditions.stream().noneMatch(b -> b instanceof BlockCondition || b instanceof BlocksCondition)) {
                        notBlockConditions = notConditions.stream().map(NotCondition::getConditions).flatMap(Collection::stream).filter(c -> c instanceof BlockCondition || c instanceof BlocksCondition || c instanceof BlockHardnessCondition).toList();
                        allowedBlocks = new HashSet<class_2248>(this.getOreBlocks());
                        deniedBlocks = new HashSet();
                        for (ICondition notBlockCondition : notBlockConditions) {
                            if (notBlockCondition instanceof BlockCondition) {
                                nbc = (BlockCondition)notBlockCondition;
                                deniedBlocks.add(nbc.getBlock());
                            } else if (notBlockCondition instanceof BlocksCondition) {
                                nbcs = (BlocksCondition)notBlockCondition;
                                deniedBlocks.addAll(nbcs.getBlocks());
                            } else if (notBlockCondition instanceof BlockHardnessCondition) {
                                BlockHardnessCondition blockHardnessCondition = (BlockHardnessCondition)notBlockCondition;
                                for (class_2248 class_22485 : allowedBlocks) {
                                    hardness = class_22485.method_9564().method_26214((class_1922)Objects.requireNonNull(level), class_2338.field_10980);
                                    if (blockHardnessCondition.getMin() > hardness) {
                                        deniedBlocks.add(class_22485);
                                    }
                                    if (!(blockHardnessCondition.getMax() < hardness)) continue;
                                    deniedBlocks.add(class_22485);
                                }
                            }
                            parsedConditions.add(notBlockCondition);
                        }
                        blockConditionComponent = new BlockConditionComponent(allowedBlocks, deniedBlocks, parentBounds);
                        blockConditionComponent.method_46419(yOffset);
                        this.addComponent((IComponent)blockConditionComponent);
                        yOffset += blockConditionComponent.method_25364();
                        parsedConditions.add(isOreCondition);
                        continue;
                    }
                }
                if (condition instanceof ItemCondition || condition instanceof ItemsCondition) {
                    List<ICondition> itemConditions = conditions.stream().filter(c -> c instanceof ItemCondition || c instanceof ItemsCondition).toList();
                    List<ICondition> notItemConditions = notConditions.stream().map(NotCondition::getConditions).flatMap(Collection::stream).filter(c -> c instanceof ItemCondition || c instanceof ItemsCondition).toList();
                    HashSet<class_1799> allowedItems = new HashSet<class_1799>();
                    HashSet<class_1799> deniedItems = new HashSet<class_1799>();
                    for (ICondition itemCondition : itemConditions) {
                        if (itemCondition instanceof ItemCondition) {
                            bc = (ItemCondition)itemCondition;
                            allowedItems.add(bc.getItemStack());
                            parsedConditions.add(itemCondition);
                            continue;
                        }
                        if (!(itemCondition instanceof ItemsCondition)) continue;
                        bcs = (ItemsCondition)itemCondition;
                        allowedItems.addAll(bcs.getItemStacks(level.method_30349()));
                        parsedConditions.add(itemCondition);
                    }
                    for (ICondition notItemCondition : notItemConditions) {
                        if (notItemCondition instanceof ItemCondition) {
                            nbc = (ItemCondition)notItemCondition;
                            deniedItems.add(nbc.getItemStack());
                            parsedConditions.add(notItemCondition);
                            continue;
                        }
                        if (!(notItemCondition instanceof ItemsCondition)) continue;
                        nbcs = (ItemsCondition)notItemCondition;
                        deniedItems.addAll(nbcs.getItemStacks(level.method_30349()));
                        parsedConditions.add(notItemCondition);
                    }
                    ItemConditionComponent itemConditionComponent = new ItemConditionComponent(allowedItems, deniedItems, parentBounds);
                    itemConditionComponent.method_46419(yOffset);
                    this.addComponent((IComponent)itemConditionComponent);
                    yOffset += itemConditionComponent.method_25364();
                    continue;
                }
                DefaultConditionComponent conditionComponent = new DefaultConditionComponent(condition);
                conditionComponent.method_46419(yOffset);
                this.addComponent((IComponent)conditionComponent);
                yOffset += conditionComponent.method_25364();
            }
            for (NotCondition notCondition : notConditions) {
                if (parsedConditions.contains(notCondition)) continue;
                for (ICondition innerCondition : notCondition.getConditions()) {
                    if (parsedConditions.contains(innerCondition)) continue;
                    NotConditionComponent notConditionComponent = new NotConditionComponent(notCondition, innerCondition);
                    notConditionComponent.method_46419(yOffset);
                    this.addComponent((IComponent)notConditionComponent);
                    yOffset += notConditionComponent.method_25364();
                    parsedConditions.add(innerCondition);
                }
                parsedConditions.add(notCondition);
            }
            this.setHeight(yOffset);
        }
    }

    private List<NotCondition> getNotConditions(List<ICondition> conditions) {
        return conditions.stream().filter(c -> c instanceof NotCondition).map(c -> (NotCondition)c).toList();
    }

    private List<class_2248> getOreBlocks() {
        if (ORE_BLOCKS == null) {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return List.of();
            }
            List<class_2248> oreBlocks = level.method_30349().method_30530(class_7924.field_41254).method_10220().filter(block -> new IsOreCondition(false).isMet(new ActionDataBuilder((ArcPlayer)class_310.method_1551().field_1724, ActionType.BREAK_BLOCK).withData(ActionDataType.BLOCK_STATE, (Object)block.method_9564()).build())).toList();
            ORE_BLOCKS = oreBlocks;
            return oreBlocks;
        }
        return ORE_BLOCKS;
    }
}

