/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.jobs.components;

import com.daqem.arc.data.condition.item.ItemCondition;
import com.daqem.arc.data.condition.item.ItemsCondition;
import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.itemrestrictions.data.RestrictionType;
import com.daqem.jobsplus.client.gui.jobs.JobsScreenState;
import com.daqem.jobsplus.client.gui.jobs.components.RecipeItemComponent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.EmptyComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_310;

public class RecipesScrollContentComponent
extends EmptyComponent {
    private static final int COLUMNS = 4;
    private static final int COMPONENT_WIDTH = 24;
    private static final int GAP = 1;
    private final JobsScreenState state;

    public RecipesScrollContentComponent(JobsScreenState state) {
        super(0, 0, 99, 0);
        this.state = state;
        this.buildRecipeComponentGrid();
        int rows = (int)Math.ceil((double)this.getComponents().size() / 4.0);
        this.setHeight(rows * 25 - 1);
    }

    private void buildRecipeComponentGrid() {
        List<DisplayEntry> displayEntries = this.getDisplayEntries();
        displayEntries = this.removeDuplicateItems(displayEntries);
        displayEntries = displayEntries.stream().sorted(Comparator.comparingInt(DisplayEntry::level).thenComparing(e -> e.stack().method_7964().getString())).toList();
        for (int i = 0; i < displayEntries.size(); ++i) {
            DisplayEntry entry = displayEntries.get(i);
            int x = i % 4 * 25;
            int y = i / 4 * 25;
            this.addComponent((IComponent)new RecipeItemComponent(x, y, i, entry.restrictionTypes(), entry.level(), entry.stack()));
        }
    }

    private List<DisplayEntry> removeDuplicateItems(List<DisplayEntry> displayEntries) {
        HashMap<class_1799, ArrayList<DisplayEntry>> uniqueEntries = new HashMap<class_1799, ArrayList<DisplayEntry>>();
        for (DisplayEntry displayEntry : displayEntries) {
            class_1799 stack = class_1799.field_8037;
            for (class_1799 uniqueItemStack : uniqueEntries.keySet()) {
                if (!class_1799.method_31577((class_1799)displayEntry.stack(), (class_1799)uniqueItemStack)) continue;
                stack = uniqueItemStack;
                break;
            }
            if (stack.method_7960()) {
                uniqueEntries.put(displayEntry.stack(), new ArrayList<DisplayEntry>(List.of(displayEntry)));
                continue;
            }
            ((List)uniqueEntries.get(stack)).add(displayEntry);
        }
        ArrayList<DisplayEntry> result = new ArrayList<DisplayEntry>();
        for (List entries : uniqueEntries.values()) {
            List<DisplayEntry> orderedEntries = entries.stream().sorted(Comparator.comparingInt(DisplayEntry::level).reversed()).toList();
            HashSet<RestrictionType> combinedRestrictionTypes = new HashSet<RestrictionType>();
            for (DisplayEntry entry : orderedEntries) {
                entry.restrictionTypes.removeAll(combinedRestrictionTypes);
                combinedRestrictionTypes.addAll(entry.restrictionTypes);
                if (entry.restrictionTypes.isEmpty()) continue;
                result.add(entry);
            }
        }
        return result;
    }

    private List<DisplayEntry> getDisplayEntries() {
        Map<ItemRestriction, Integer> itemRestrictions = this.state.getSelectedJob().getJobInstance().getItemRestrictions();
        if (class_310.method_1551().field_1724 != null) {
            return itemRestrictions.entrySet().stream().flatMap(entry -> {
                ItemRestriction itemRestriction = (ItemRestriction)entry.getKey();
                int requiredLevel = (Integer)entry.getValue();
                List conditions = itemRestriction.getConditions();
                return conditions.stream().flatMap(condition -> {
                    if (condition instanceof ItemCondition) {
                        ItemCondition itemCondition = (ItemCondition)condition;
                        return Stream.of(new DisplayEntry(itemCondition.getItemStack(), requiredLevel, itemRestriction.getRestrictionTypes()));
                    }
                    if (condition instanceof ItemsCondition) {
                        ItemsCondition itemsCondition = (ItemsCondition)condition;
                        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
                        for (class_1799 item : itemsCondition.getItemStacks(class_310.method_1551().field_1724.method_56673())) {
                            entries.add(new DisplayEntry(item, requiredLevel, itemRestriction.getRestrictionTypes()));
                        }
                        return entries.stream();
                    }
                    return Stream.empty();
                });
            }).toList();
        }
        return List.of();
    }

    private record DisplayEntry(class_1799 stack, int level, List<RestrictionType> restrictionTypes) {
    }
}

