/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.condition.conditions.job.powerup;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.type.JobsPlusConditionType;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9129;

public class PowerupNotActiveCondition
extends AbstractCondition {
    private final class_2960 powerupThatShouldNotBeActiveLocation;

    public PowerupNotActiveCondition(boolean inverted, class_2960 powerupThatShouldNotBeActiveLocation) {
        super(inverted);
        this.powerupThatShouldNotBeActiveLocation = powerupThatShouldNotBeActiveLocation;
    }

    public boolean isMet(ActionData actionData) {
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof JobsPlayer) {
            JobsPlayer player = (JobsPlayer)arcPlayer;
            PowerupInstance powerupInstance = PowerupInstance.of(this.powerupThatShouldNotBeActiveLocation);
            Optional<Powerup> powerup = player.jobsplus$getJobs().stream().map(job -> job.getPowerupManager().getPowerup(powerupInstance)).filter(Optional::isPresent).map(Optional::get).findFirst();
            return powerup.isEmpty() || powerup.get().getPowerupInstance().getLocation().equals((Object)this.powerupThatShouldNotBeActiveLocation) && powerup.get().getState() != PowerupState.ACTIVE;
        }
        return false;
    }

    public IConditionType<? extends ICondition> getType() {
        return JobsPlusConditionType.POWERUP_NOT_ACTIVE;
    }

    public class_2561 getDescription() {
        PowerupInstance powerupInstance = PowerupInstance.of(this.powerupThatShouldNotBeActiveLocation);
        if (powerupInstance == null) {
            return JobsPlus.literal("ERROR: Powerup not found: '" + this.powerupThatShouldNotBeActiveLocation.toString() + "'");
        }
        return this.getDescription(new Object[]{powerupInstance.getName()});
    }

    public static class Serializer
    implements IConditionSerializer<PowerupNotActiveCondition> {
        public PowerupNotActiveCondition fromJson(class_2960 location, JsonObject jsonObject, boolean inverted) {
            return new PowerupNotActiveCondition(inverted, this.getResourceLocation(jsonObject, "powerup"));
        }

        public PowerupNotActiveCondition fromNetwork(class_2960 location, class_9129 friendlyByteBuf, boolean inverted) {
            return new PowerupNotActiveCondition(inverted, friendlyByteBuf.method_10810());
        }

        public void toNetwork(class_9129 friendlyByteBuf, PowerupNotActiveCondition type) {
            super.toNetwork(friendlyByteBuf, (ICondition)type);
            friendlyByteBuf.method_10812(type.powerupThatShouldNotBeActiveLocation);
        }
    }
}

