/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.gui.powerups.widgets;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.gui.confimation.ConfirmationScreen;
import com.daqem.jobsplus.client.gui.confimation.ConfirmationScreenState;
import com.daqem.jobsplus.client.gui.powerups.PowerupsScreen;
import com.daqem.jobsplus.client.gui.powerups.PowerupsScreenState;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.c2s.ServerboundOpenPowerupsScreenPacket;
import com.daqem.jobsplus.networking.c2s.ServerboundStartPowerupPacket;
import com.daqem.jobsplus.networking.c2s.ServerboundTogglePowerUpPacket;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.daqem.uilib.api.skilltree.ISkillTreeItem;
import com.daqem.uilib.api.widget.skilltree.ISkillTreeItemWidget;
import com.daqem.uilib.gui.component.text.multiline.MultiLineTextComponent;
import com.daqem.uilib.gui.widget.CustomButtonWidget;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_10799;
import net.minecraft.class_11910;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8710;

public class PowerupItemWidget
extends CustomButtonWidget
implements ISkillTreeItemWidget {
    private final ISkillTreeItem skillTreeItem;
    private final PowerupsScreenState state;
    private final Powerup powerup;

    public PowerupItemWidget(ISkillTreeItem skillTreeItem, PowerupsScreenState state, Powerup powerup) {
        super(0, 0, 26, 26, (class_2561)(powerup != null ? powerup.getPowerupInstance().getName() : state.getJob().getJobInstance().getName()), null, btn -> {
            PowerupItemWidget button;
            if (btn instanceof PowerupItemWidget && (button = (PowerupItemWidget)btn).method_37303()) {
                Powerup powerUp = button.getPowerup();
                PowerupInstance powerupInstance = powerUp.getPowerupInstance();
                class_2960 location = button.getState().getJob().getJobInstance().getLocation();
                if (powerUp.getState() == PowerupState.ACTIVE || powerUp.getState() == PowerupState.INACTIVE) {
                    NetworkManager.sendToServer((class_8710)new ServerboundTogglePowerUpPacket(location, powerupInstance.getLocation()));
                    class_437 patt0$temp = class_310.method_1551().field_1755;
                    if (patt0$temp instanceof PowerupsScreen) {
                        PowerupsScreen powerupsScreen = (PowerupsScreen)patt0$temp;
                        button.getPowerup().setState(powerUp.getState() == PowerupState.ACTIVE ? PowerupState.INACTIVE : PowerupState.ACTIVE);
                    }
                } else if (powerUp.getState() == PowerupState.NOT_OWNED) {
                    class_310.method_1551().method_1507((class_437)new ConfirmationScreen(class_310.method_1551().field_1755, new ConfirmationScreenState((class_2561)JobsPlus.translatable("gui.confirmation.purchase_powerup", powerupInstance.getName(), powerupInstance.getPrice()), () -> {
                        NetworkManager.sendToServer((class_8710)new ServerboundStartPowerupPacket(location, powerupInstance.getLocation()));
                        NetworkManager.sendToServer((class_8710)new ServerboundOpenPowerupsScreenPacket(location));
                    })));
                }
            }
        });
        this.skillTreeItem = skillTreeItem;
        this.state = state;
        this.powerup = powerup;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.blitSlot(guiGraphics);
    }

    public PowerupsScreenState getState() {
        return this.state;
    }

    public Powerup getPowerup() {
        return this.powerup;
    }

    private class_2960 getSprite() {
        class_2960 defaultSprite = JobsPlus.getId("powerups/slot_active");
        class_2960 lockedSprite = JobsPlus.getId("powerups/slot_locked");
        class_2960 notOwnedSprite = JobsPlus.getId("powerups/slot_not_owned");
        if (this.powerup == null) {
            Job job = this.state.getJob();
            if (job.getLevel() > 0) {
                return defaultSprite;
            }
            if (this.state.getCoins() >= job.getJobInstance().getPrice()) {
                return notOwnedSprite;
            }
            return lockedSprite;
        }
        if (!(this.hasPowerup() || this.hasEnoughCoins() && this.hasRequiredLevel())) {
            return lockedSprite;
        }
        return switch (this.powerup.getState()) {
            default -> throw new MatchException(null, null);
            case PowerupState.ACTIVE -> defaultSprite;
            case PowerupState.INACTIVE -> JobsPlus.getId("powerups/slot_inactive");
            case PowerupState.NOT_OWNED -> notOwnedSprite;
            case PowerupState.LOCKED -> lockedSprite;
        };
    }

    private void blitSlot(class_332 guiGraphics) {
        guiGraphics.method_52706(class_10799.field_56883, this.getSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        class_1799 icon = this.powerup != null ? this.powerup.getPowerupInstance().getIcon() : this.state.getJob().getJobInstance().getIconItem();
        guiGraphics.method_51445(icon, this.method_46426() + 5, this.method_46427() + 5);
        guiGraphics.method_51431(class_310.method_1551().field_1772, icon, this.method_46426() + 5, this.method_46427() + 5);
    }

    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            class_5250 title = this.powerup != null ? this.powerup.getPowerupInstance().getName() : this.state.getJob().getJobInstance().getName();
            class_5250 description = this.powerup != null ? this.powerup.getPowerupInstance().getDescription() : this.state.getJob().getJobInstance().getDescription();
            int titleWidth = Math.max(50, class_310.method_1551().field_1772.method_27525((class_5348)title));
            MultiLineTextComponent descriptionComponent = new MultiLineTextComponent(0, 0, titleWidth + this.method_25368() + 10, (class_2561)description, -14806000);
            if (this.method_46426() + this.method_25368() + titleWidth + 18 > guiGraphics.method_51421()) {
                guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("powerups/text_background"), this.method_46426() - titleWidth - 18, this.method_46427() + 7, this.method_25368() + titleWidth + 24, 20 + descriptionComponent.method_25364() + 6 + (this.powerup != null && this.powerup.getPowerupInstance().getRequiredLevel() > 0 ? 25 : 13));
                guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("powerups/bar"), this.method_46426() - titleWidth - 18, this.method_46427() + 3, this.method_25368() + titleWidth + 24, 20);
                guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)title, this.method_46426() - titleWidth - 6, this.method_46427() + 9, -14806000, false);
                if (this.powerup != null) {
                    guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("powerups/line"), this.method_46426() - titleWidth - 12, this.method_46427() + 29 + descriptionComponent.method_25364() + 1, 30, 1);
                    int requiredLevel = this.powerup.getPowerupInstance().getRequiredLevel();
                    if (requiredLevel > 0) {
                        guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)JobsPlus.translatable("gui.powerups.required_level", requiredLevel), this.method_46426() - titleWidth - 11, this.method_46427() + 29 + descriptionComponent.method_25364() + 4, -14806000, false);
                    }
                    class_5250 price = JobsPlus.translatable("gui.powerups.price", this.powerup.getPowerupInstance().getPrice());
                    guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)price, this.method_46426() - titleWidth - 11, this.method_46427() + 29 + descriptionComponent.method_25364() + (requiredLevel > 0 ? 15 : 4), -14806000, false);
                    guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("jobs/coins"), this.method_46426() - titleWidth - 11 + class_310.method_1551().field_1772.method_27525((class_5348)price) + 2, this.method_46427() + 29 + descriptionComponent.method_25364() + (requiredLevel > 0 ? 15 : 4), 7, 8);
                }
                descriptionComponent.method_46421(this.method_46426() - titleWidth - 11);
                descriptionComponent.method_46419(this.method_46427() + 29);
                descriptionComponent.renderBase(guiGraphics, mouseX, mouseY, 0.0f, 0, 0);
            } else {
                guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("powerups/text_background"), this.method_46426() - 6, this.method_46427() + 7, this.method_25368() + titleWidth + 24, 20 + descriptionComponent.method_25364() + 6 + (this.powerup != null && this.powerup.getPowerupInstance().getRequiredLevel() > 0 ? 25 : 13));
                guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("powerups/bar"), this.method_46426() - 6, this.method_46427() + 3, this.method_25368() + titleWidth + 24, 20);
                guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)title, this.method_46426() + this.method_25368() + 8, this.method_46427() + 9, -14806000, false);
                if (this.powerup != null) {
                    guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("powerups/line"), this.method_46426(), this.method_46427() + 29 + descriptionComponent.method_25364() + 1, 30, 1);
                    int requiredLevel = this.powerup.getPowerupInstance().getRequiredLevel();
                    if (requiredLevel > 0) {
                        guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)JobsPlus.translatable("gui.powerups.required_level", requiredLevel), this.method_46426() + 1, this.method_46427() + 29 + descriptionComponent.method_25364() + 4, -14806000, false);
                    }
                    class_5250 price = JobsPlus.translatable("gui.powerups.price", this.powerup.getPowerupInstance().getPrice());
                    guiGraphics.method_51439(class_310.method_1551().field_1772, (class_2561)price, this.method_46426() + 1, this.method_46427() + 29 + descriptionComponent.method_25364() + (requiredLevel > 0 ? 15 : 4), -14806000, false);
                    guiGraphics.method_52706(class_10799.field_56883, JobsPlus.getId("jobs/coins"), this.method_46426() + 1 + class_310.method_1551().field_1772.method_27525((class_5348)price) + 2, this.method_46427() + 29 + descriptionComponent.method_25364() + (requiredLevel > 0 ? 15 : 4), 7, 8);
                }
                descriptionComponent.method_46421(this.method_46426() + 1);
                descriptionComponent.method_46419(this.method_46427() + 29);
                descriptionComponent.renderBase(guiGraphics, mouseX, mouseY, 0.0f, 0, 0);
            }
            this.blitSlot(guiGraphics);
        }
    }

    public ISkillTreeItem getSkillTreeItem() {
        return this.skillTreeItem;
    }

    protected boolean method_25351(class_11910 mouseButtonInfo) {
        if (this.hasPowerup()) {
            return true;
        }
        boolean isCorrectPowerupState = this.powerup != null && this.powerup.getState() != PowerupState.LOCKED;
        return isCorrectPowerupState && this.hasEnoughCoins() && this.hasRequiredLevel();
    }

    public boolean method_37303() {
        return this.method_25351(new class_11910(0, 0));
    }

    private boolean hasEnoughCoins() {
        return this.powerup != null && this.state.getCoins() >= this.powerup.getPowerupInstance().getPrice();
    }

    private boolean hasRequiredLevel() {
        return this.powerup != null && this.state.getJob().getLevel() >= 1 && this.state.getJob().getLevel() >= this.powerup.getPowerupInstance().getRequiredLevel();
    }

    private boolean hasPowerup() {
        return this.powerup != null && (this.powerup.getState() == PowerupState.ACTIVE || this.powerup.getState() == PowerupState.INACTIVE);
    }
}

