/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.job;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.JobsPlusExpectPlatform;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.NotNull;

public class JobManager
extends class_4080<List<IActionHolder>> {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(JobInstance.class, (Object)new JobInstance.Serializer()).create();
    private static JobManager instance;

    public JobManager() {
        instance = this;
    }

    @NotNull
    protected List<IActionHolder> prepare(class_3300 resourceManager, class_3695 profilerFiller) {
        Map<class_2960, class_3298> resourceMap = resourceManager.method_14488("jobsplus/jobs", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).entrySet().stream().collect(Collectors.toMap(entry -> class_2960.method_60655((String)((class_2960)entry.getKey()).method_12836(), (String)((class_2960)entry.getKey()).method_12832().substring(0, ((class_2960)entry.getKey()).method_12832().length() - ".json".length()).substring("jobsplus/jobs/".length())), Map.Entry::getValue));
        HashMap<class_2960, JsonObject> map = new HashMap<class_2960, JsonObject>();
        for (Map.Entry<class_2960, class_3298> entry2 : resourceMap.entrySet()) {
            class_2960 location = entry2.getKey();
            try {
                JsonObject jsonElement = class_3518.method_15255((Reader)entry2.getValue().method_43039());
                map.put(location, jsonElement);
            }
            catch (Exception runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading job {}", (Object)location, (Object)runtimeException);
            }
        }
        ArrayList<IActionHolder> jobs = new ArrayList<IActionHolder>();
        if (!JobsPlus.isDebugEnvironment()) {
            map.entrySet().removeIf(entry -> ((class_2960)entry.getKey()).method_12836().equals("debug"));
        }
        for (Map.Entry entry3 : map.entrySet()) {
            class_2960 location = (class_2960)entry3.getKey();
            JsonObject jsonObject = (JsonObject)entry3.getValue();
            jsonObject.addProperty("location", location.toString());
            try {
                JobInstance job = (JobInstance)((Object)GSON.fromJson((JsonElement)entry3.getValue(), JobInstance.class));
                jobs.add((IActionHolder)job);
            }
            catch (JsonParseException | IllegalArgumentException runtimeException) {
                JobsPlus.LOGGER.error("Parsing error loading job {}", (Object)location, (Object)runtimeException);
            }
        }
        return jobs;
    }

    protected void apply(List<IActionHolder> jobs, class_3300 resourceManager, class_3695 profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActionHoldersForType(JobsPlusActionHolderType.JOB_INSTANCE);
        actionHolderManager.registerActionHolders(jobs);
        JobsPlus.LOGGER.info("Loaded {} jobs", (Object)jobs.size());
    }

    public static JobManager getInstance() {
        return instance != null ? instance : JobsPlusExpectPlatform.getJobManager();
    }

    public Map<class_2960, JobInstance> getJobs() {
        return ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> actionHolder instanceof JobInstance).map(actionHolder -> (JobInstance)((Object)actionHolder)).collect(Collectors.toMap(AbstractActionHolder::getLocation, jobInstance -> jobInstance));
    }
}

