/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.c2s;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class ServerboundStartPowerupPacket
implements class_8710 {
    private final class_2960 jobLocation;
    private final class_2960 powerupLocation;
    public static final class_9139<class_9129, ServerboundStartPowerupPacket> STREAM_CODEC = new class_9139<class_9129, ServerboundStartPowerupPacket>(){

        @NotNull
        public ServerboundStartPowerupPacket decode(class_9129 buf) {
            return new ServerboundStartPowerupPacket(buf);
        }

        public void encode(class_9129 buf, ServerboundStartPowerupPacket packet) {
            buf.method_10812(packet.jobLocation);
            buf.method_10812(packet.powerupLocation);
        }
    };

    public ServerboundStartPowerupPacket(class_2960 jobLocation, class_2960 powerupLocation) {
        this.jobLocation = jobLocation;
        this.powerupLocation = powerupLocation;
    }

    public ServerboundStartPowerupPacket(class_9129 friendlyByteBuf) {
        this.jobLocation = friendlyByteBuf.method_10810();
        this.powerupLocation = friendlyByteBuf.method_10810();
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return JobsPlusNetworking.SERVERBOUND_START_POWERUP;
    }

    public static void handleServerSide(ServerboundStartPowerupPacket packet, NetworkManager.PacketContext context) {
        class_1657 class_16572 = context.getPlayer();
        if (class_16572 instanceof JobsServerPlayer) {
            JobsServerPlayer serverPlayer = (JobsServerPlayer)class_16572;
            Job job = serverPlayer.jobsplus$getJob(packet.jobLocation);
            PowerupInstance powerupInstance = PowerupInstance.of(packet.powerupLocation);
            if (job == null) {
                serverPlayer.jobsplus$getServerPlayer().method_64398((class_2561)JobsPlus.translatable("error.job_not_found", packet.jobLocation.toString()));
                return;
            }
            if (powerupInstance == null) {
                serverPlayer.jobsplus$getServerPlayer().method_64398((class_2561)JobsPlus.translatable("error.powerup_not_found", packet.powerupLocation.toString()));
                return;
            }
            if (serverPlayer.jobsplus$getCoins() < powerupInstance.getPrice()) {
                serverPlayer.jobsplus$getServerPlayer().method_64398((class_2561)JobsPlus.translatable("error.not_enough_coins"));
                return;
            }
            if (job.getLevel() < powerupInstance.getRequiredLevel()) {
                serverPlayer.jobsplus$getServerPlayer().method_64398((class_2561)JobsPlus.translatable("error.not_high_enough_level"));
                return;
            }
            if (job.getPowerupManager().getPowerup(powerupInstance).isPresent()) {
                serverPlayer.jobsplus$getServerPlayer().method_64398((class_2561)JobsPlus.translatable("error.powerup_already_owned", powerupInstance.getName()));
                return;
            }
            if (job.getPowerupManager().addPowerup(serverPlayer, job, powerupInstance)) {
                serverPlayer.jobsplus$setCoins(serverPlayer.jobsplus$getCoins() - powerupInstance.getPrice());
            } else {
                serverPlayer.jobsplus$getServerPlayer().method_64398((class_2561)JobsPlus.translatable("error.could_not_add_powerup", powerupInstance.getName()));
            }
        }
    }
}

