/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.reward.rewards.job;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.result.ActionResult;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.arc.api.reward.AbstractReward;
import com.daqem.arc.api.reward.IReward;
import com.daqem.arc.api.reward.serializer.IRewardSerializer;
import com.daqem.arc.api.reward.type.IRewardType;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.data.type.JobsPlusActionDataType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.integration.arc.reward.type.JobsPlusRewardType;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.google.gson.JsonObject;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9129;

public class JobExpMultiplierReward
extends AbstractReward {
    private final class_2960 jobLocation;
    private final double multiplier;

    public JobExpMultiplierReward(double chance, int priority, class_2960 jobLocation, double multiplier) {
        super(chance, priority);
        this.jobLocation = jobLocation;
        this.multiplier = multiplier;
    }

    public IRewardType<?> getType() {
        return JobsPlusRewardType.JOB_EXP_MULTIPLIER;
    }

    public ActionResult apply(ActionData actionData) {
        IActionHolder sourceActionHolder = actionData.getSourceActionHolder();
        ArcPlayer player = actionData.getPlayer();
        if (player instanceof JobsServerPlayer) {
            Double exp;
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)player;
            Job job = (Job)actionData.getData(JobsPlusActionDataType.ONLY_FOR_JOB);
            if (job == null) {
                if (sourceActionHolder instanceof JobInstance) {
                    JobInstance jobInstance = (JobInstance)sourceActionHolder;
                    if (!jobInstance.getLocation().equals((Object)this.jobLocation)) {
                        return new ActionResult();
                    }
                    job = jobsServerPlayer.jobsplus$getJob(jobInstance);
                } else if (sourceActionHolder instanceof PowerupInstance) {
                    PowerupInstance powerupInstance = (PowerupInstance)sourceActionHolder;
                    if (!powerupInstance.getJobLocation().equals((Object)this.jobLocation)) {
                        return new ActionResult();
                    }
                    job = jobsServerPlayer.jobsplus$getJob(JobInstance.of(powerupInstance.getJobLocation()));
                }
            } else if (!job.getJobInstance().getLocation().equals((Object)this.jobLocation)) {
                return new ActionResult();
            }
            if (job != null && (exp = (Double)actionData.getData(JobsPlusActionDataType.JOB_EXP)) != null) {
                double experience = (double)((int)(exp * this.multiplier)) - exp;
                job.addExperienceWithoutEvent(experience);
            }
        }
        return new ActionResult();
    }

    public class_2561 getDescription() {
        JobInstance jobInstance = JobInstance.of(this.jobLocation);
        if (jobInstance == null) {
            return JobsPlus.literal("ERROR: Job not found: '" + this.jobLocation.toString() + "'");
        }
        return this.getDescription(new Object[]{jobInstance.getName(), this.multiplier});
    }

    public static class Serializer
    implements IRewardSerializer<JobExpMultiplierReward> {
        public JobExpMultiplierReward fromJson(JsonObject jsonObject, double chance, int priority) {
            return new JobExpMultiplierReward(chance, priority, this.getResourceLocation(jsonObject, "job"), class_3518.method_34927((JsonObject)jsonObject, (String)"multiplier"));
        }

        public JobExpMultiplierReward fromNetwork(class_9129 friendlyByteBuf, double chance, int priority) {
            return new JobExpMultiplierReward(chance, priority, friendlyByteBuf.method_10810(), friendlyByteBuf.readDouble());
        }

        public void toNetwork(class_9129 friendlyByteBuf, JobExpMultiplierReward type) {
            super.toNetwork(friendlyByteBuf, (IReward)type);
            friendlyByteBuf.method_10812(type.jobLocation);
            friendlyByteBuf.method_52940(type.multiplier);
        }
    }
}

