/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.jobs;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.powerup.PowerupTreeContainerComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.api.client.gui.texture.INineSlicedTexture;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.component.texture.NineSlicedTextureComponent;
import com.daqem.uilib.client.gui.text.Text;
import com.daqem.uilib.client.gui.texture.Textures;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class JobPowerupsComponent
extends AbstractComponent<JobPowerupsComponent> {
    private final JobsScreenOptions options;
    private final Map<Job, PowerupTreeContainerComponent> powerupTreeContainerComponents = new HashMap<Job, PowerupTreeContainerComponent>();
    private Job cachedJob;

    public JobPowerupsComponent(int x, int y, int width, int height, JobsScreenOptions options) {
        super(null, x, y, width, height);
        this.options = options;
        this.cachedJob = options.getSelectedJob();
        Font font = Minecraft.getInstance().font;
        Text titleText = new Text(font, (Component)JobsPlus.translatable("gui.tab.right.power_ups"), 7, 0);
        titleText.setTextColor(ChatFormatting.DARK_GRAY);
        TextComponent titleComponent = new TextComponent((IText)titleText);
        Objects.requireNonNull(font);
        PowerupTreeContainerComponent powerupTreeContainerComponent = new PowerupTreeContainerComponent(8, 9 + 1, width - 16, height - 2, options);
        this.powerupTreeContainerComponents.put(options.getSelectedJob(), powerupTreeContainerComponent);
        Objects.requireNonNull(font);
        NineSlicedTextureComponent background = new NineSlicedTextureComponent((INineSlicedTexture)Textures.SCROLL_BAR_BACKGROUND, 7, 9, width - 14, height);
        this.addChild((IComponent)background);
        this.addChild((IComponent)titleComponent);
        this.addChild((IComponent)powerupTreeContainerComponent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.isVisible() && this.cachedJob != this.options.getSelectedJob()) {
            this.removeChild((IComponent)this.powerupTreeContainerComponents.get(this.cachedJob));
            this.cachedJob = this.options.getSelectedJob();
            if (this.powerupTreeContainerComponents.containsKey(this.cachedJob)) {
                this.addChild((IComponent)this.powerupTreeContainerComponents.get(this.cachedJob));
            } else {
                Objects.requireNonNull(Minecraft.getInstance().font);
                PowerupTreeContainerComponent powerupTreeContainerComponent = new PowerupTreeContainerComponent(8, 9 + 1, this.getWidth() - 16, this.getHeight() - 2, this.options);
                this.powerupTreeContainerComponents.put(this.cachedJob, powerupTreeContainerComponent);
                this.addChild((IComponent)powerupTreeContainerComponent);
            }
        }
    }
}

