/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.jobs;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.JobsButtonComponent;
import com.daqem.jobsplus.client.components.ModalComponent;
import com.daqem.jobsplus.client.components.TabGroupComponent;
import com.daqem.jobsplus.client.components.jobs.JobExperienceComponent;
import com.daqem.jobsplus.client.components.jobs.JobInfoComponent;
import com.daqem.jobsplus.client.components.jobs.JobItemRestrictionsComponent;
import com.daqem.jobsplus.client.components.jobs.JobPowerupsComponent;
import com.daqem.jobsplus.client.components.jobs.JobsBackgroundComponent;
import com.daqem.jobsplus.client.components.jobs.JobsScrollComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.client.screen.job.tab.LeftTab;
import com.daqem.jobsplus.client.screen.job.tab.RightTab;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.networking.c2s.ServerboundStartJobPacket;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.component.io.ButtonComponent;
import com.daqem.uilib.client.gui.text.Text;
import dev.architectury.networking.NetworkManager;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class JobsComponent
extends AbstractComponent<JobsComponent> {
    public static final int WIDTH = 326;
    public static final int HEIGHT = 166;
    public static final int GAP = 3;
    public static final int LEFT = 147;
    public static final int RIGHT = 176;
    private static final Font font = Minecraft.getInstance().font;
    private final JobsScreenOptions options;
    private final TextComponent coinsComponent;
    private final JobInfoComponent jobInfoComponent;
    private final JobItemRestrictionsComponent jobItemRestrictionsComponent;
    private final JobPowerupsComponent jobPowerupsComponent;
    private final JobExperienceComponent jobExperienceComponent;
    private final JobsButtonComponent startJobButtonComponent;
    private final ModalComponent modalComponent;
    private Job cachedJob;
    private double cachedCoins;

    public JobsComponent(Component title, JobsScreenOptions options, ModalComponent modalComponent) {
        super(null, 0, 0, 326, 166);
        this.options = options;
        this.modalComponent = modalComponent;
        this.cachedJob = options.getSelectedJob();
        this.cachedCoins = options.getCoins();
        this.center();
        Text titleText = new Text(font, title, 7, 6);
        Text coinsText = new Text(font, (Component)JobsPlus.translatable("gui.coins.top", JobsPlus.formatNumber(options.getCoins())), 147, 6);
        JobsBackgroundComponent jobsBackgroundComponent = new JobsBackgroundComponent(326, 166, 147, 176);
        TextComponent titleComponent = new TextComponent((IText)titleText);
        JobsScrollComponent jobsScrollComponent = new JobsScrollComponent(7, 15, 116, 140, options);
        this.coinsComponent = new TextComponent((IText)coinsText);
        TabGroupComponent leftTabsGroupComponent = new TabGroupComponent(Stream.of(LeftTab.values()).map(LeftTab::getOptions).toList(), 0, -28, options);
        TabGroupComponent rightTabsGroupComponent = new TabGroupComponent(Stream.of(RightTab.values()).map(RightTab::getOptions).toList(), 150, -28, options);
        this.jobInfoComponent = new JobInfoComponent(150, 6, 176, 140, options);
        this.jobItemRestrictionsComponent = new JobItemRestrictionsComponent(150, 6, 176, 140, options);
        this.jobPowerupsComponent = new JobPowerupsComponent(150, 6, 176, 140, options);
        this.jobExperienceComponent = new JobExperienceComponent(150, 6, 176, 140, options);
        this.startJobButtonComponent = new JobsButtonComponent(0, 169, 326, 20, (Component)JobsPlus.translatable("gui.job.start"), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject, screen, mouseX, mouseY, button) -> {
            JobInstance jobInstance = options.getSelectedJob().getJobInstance();
            if ((Integer)JobsPlusConfig.amountOfFreeJobs.get() <= options.getPreformingJobs().size() && (double)jobInstance.getPrice() > options.getCoins()) {
                this.openModal((Component)JobsPlus.translatable("gui.jobs.not_enough_coins.title"), (Component)JobsPlus.translatable("gui.jobs.not_enough_coins.description"), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject1, screen1, mouseX1, mouseY1, button1) -> {
                    ModalComponent modal = (ModalComponent)clickedObject1.getParent();
                    if (modal != null) {
                        modal.close();
                    }
                    return true;
                }), true);
            } else if ((Integer)JobsPlusConfig.maxJobs.get() <= options.getPreformingJobs().size()) {
                this.openModal((Component)JobsPlus.translatable("gui.jobs.max_jobs_reached.title"), (Component)JobsPlus.translatable("gui.jobs.max_jobs_reached.description"), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject1, screen1, mouseX1, mouseY1, button1) -> {
                    ModalComponent modal = (ModalComponent)clickedObject1.getParent();
                    if (modal != null) {
                        modal.close();
                    }
                    return true;
                }), true);
            } else {
                this.openModal((Component)JobsPlus.translatable("gui.job.start"), (Component)((Integer)JobsPlusConfig.amountOfFreeJobs.get() > options.getPreformingJobs().size() ? JobsPlus.translatable("gui.job.start.description.free", jobInstance.getName().withColor(jobInstance.getColorDecimal())) : JobsPlus.translatable("gui.job.start.description.not_free", jobInstance.getName().withColor(jobInstance.getColorDecimal()), JobsPlus.literal(String.valueOf(jobInstance.getPrice())).withColor(jobInstance.getColorDecimal()))), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject1, screen1, mouseX1, mouseY1, button1) -> {
                    NetworkManager.sendToServer((CustomPacketPayload)new ServerboundStartJobPacket(jobInstance.getLocation()));
                    return true;
                }), false);
            }
            return true;
        }));
        titleText.setTextColor(ChatFormatting.DARK_GRAY);
        coinsText.setTextColor(ChatFormatting.DARK_GRAY);
        this.jobInfoComponent.setVisible(options.getSelectedRightTab() == RightTab.INFO);
        this.jobItemRestrictionsComponent.setVisible(options.getSelectedRightTab() == RightTab.CRAFTING);
        this.jobPowerupsComponent.setVisible(options.getSelectedRightTab() == RightTab.POWER_UPS);
        this.jobExperienceComponent.setVisible(options.getSelectedRightTab() == RightTab.EXP);
        this.addChild((IComponent)jobsBackgroundComponent);
        this.addChild((IComponent)titleComponent);
        this.addChild((IComponent)jobsScrollComponent);
        this.addChild((IComponent)this.coinsComponent);
        this.addChild((IComponent)leftTabsGroupComponent);
        this.addChild((IComponent)rightTabsGroupComponent);
        this.addChild((IComponent)this.jobInfoComponent);
        this.addChild((IComponent)this.jobItemRestrictionsComponent);
        this.addChild((IComponent)this.jobPowerupsComponent);
        this.addChild((IComponent)this.jobExperienceComponent);
        this.addChild((IComponent)this.startJobButtonComponent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.coinsComponent.setX(-this.coinsComponent.getWidth() - 7);
        this.jobInfoComponent.setVisible(this.options.getSelectedRightTab() == RightTab.INFO);
        this.jobItemRestrictionsComponent.setVisible(this.options.getSelectedRightTab() == RightTab.CRAFTING);
        this.jobPowerupsComponent.setVisible(this.options.getSelectedRightTab() == RightTab.POWER_UPS);
        this.jobExperienceComponent.setVisible(this.options.getSelectedRightTab() == RightTab.EXP);
        if (this.cachedJob != this.options.getSelectedJob()) {
            this.cachedJob = this.options.getSelectedJob();
            this.jobItemRestrictionsComponent.resetScroll();
            this.jobExperienceComponent.resetScroll();
        }
        if (this.cachedCoins != this.options.getCoins()) {
            this.cachedCoins = this.options.getCoins();
            if (this.coinsComponent.getText() != null) {
                MutableComponent component = JobsPlus.translatable("gui.coins.top", JobsPlus.formatNumber(this.options.getCoins()));
                int width = font.width((FormattedText)component);
                this.coinsComponent.getText().setText((Component)component);
                this.coinsComponent.getText().setWidth(width);
                this.coinsComponent.setWidth(width);
            }
        }
        this.startJobButtonComponent.setVisible(this.options.getNotPreformingJobs().contains(this.options.getSelectedJob()) && (Integer)JobsPlusConfig.maxJobs.get() > this.options.getPreformingJobs().size());
    }

    public void openModal(Component title, Component description, OnClickEvent<ButtonComponent> confirmEvent, boolean onlyConfirm) {
        Objects.requireNonNull(this.modalComponent.getTitle().getText()).setText(title);
        Objects.requireNonNull(this.modalComponent.getDescription().getText()).setText(description);
        this.modalComponent.getConfirmButton().setOnClickEvent(confirmEvent);
        this.modalComponent.getCancelButton().setVisible(!onlyConfirm);
        if (onlyConfirm) {
            this.modalComponent.getConfirmButton().setX(this.modalComponent.getWidth() / 4);
        } else {
            this.modalComponent.getConfirmButton().setX((this.modalComponent.getWidth() + 3) / 2);
        }
        this.modalComponent.setVisible(true);
    }

    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        if (this.modalComponent.isVisible()) {
            return false;
        }
        return super.preformOnClickEvent(mouseX, mouseY, button);
    }

    public ModalComponent getModalComponent() {
        return this.modalComponent;
    }
}

