/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.toast;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class LevelUpJobToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final long DISPLAY_TIME = 5000L;
    private final JobInstance jobInstance;
    private final int level;
    private long lastChanged;
    private boolean changed;

    public LevelUpJobToast(JobInstance jobInstance, int level) {
        this.jobInstance = jobInstance;
        this.level = level;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long l) {
        if (this.changed) {
            this.lastChanged = l;
            this.changed = false;
        }
        if (this.jobInstance == null) {
            return Toast.Visibility.HIDE;
        }
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        guiGraphics.drawString(toastComponent.getMinecraft().font, (Component)this.jobInstance.getName(), 30, 7, this.jobInstance.getColorDecimal(), false);
        guiGraphics.drawString(toastComponent.getMinecraft().font, (Component)JobsPlus.translatable("job.level_up.toast", this.level), 30, 18, -16777216, false);
        guiGraphics.renderFakeItem(this.jobInstance.getIconItem(), 8, 8);
        return (double)(l - this.lastChanged) >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    public static void add(ToastComponent toastComponent, JobInstance jobInstance, int level) {
        toastComponent.addToast((Toast)new LevelUpJobToast(jobInstance, level));
    }
}

