/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.condition.conditions.job;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.integration.arc.condition.type.JobsPlusConditionType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class JobExperiencePercentageCondition
extends AbstractCondition {
    private final double percentage;

    public JobExperiencePercentageCondition(boolean inverted, double percentage) {
        super(inverted);
        this.percentage = percentage;
    }

    public boolean isMet(ActionData actionData) {
        IActionHolder iActionHolder = actionData.getSourceActionHolder();
        if (iActionHolder instanceof JobInstance) {
            JobsServerPlayer jobsServerPlayer;
            Job job;
            JobInstance jobInstance = (JobInstance)iActionHolder;
            ArcPlayer arcPlayer = actionData.getPlayer();
            if (arcPlayer instanceof JobsServerPlayer && (job = (jobsServerPlayer = (JobsServerPlayer)arcPlayer).jobsplus$getJob(jobInstance)) != null) {
                return job.getExperiencePercentage() >= this.percentage;
            }
        }
        return false;
    }

    public IConditionType<? extends ICondition> getType() {
        return JobsPlusConditionType.JOB_EXPERIENCE_PERCENTAGE;
    }

    public Component getDescription() {
        return this.getDescription(new Object[]{this.percentage});
    }

    public static class Serializer
    implements IConditionSerializer<JobExperiencePercentageCondition> {
        public JobExperiencePercentageCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new JobExperiencePercentageCondition(inverted, GsonHelper.getAsDouble((JsonObject)jsonObject, (String)"percentage"));
        }

        public JobExperiencePercentageCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            return new JobExperiencePercentageCondition(inverted, friendlyByteBuf.readDouble());
        }

        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, JobExperiencePercentageCondition type) {
            super.toNetwork(friendlyByteBuf, (ICondition)type);
            friendlyByteBuf.writeDouble(type.percentage);
        }
    }
}

