/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.job;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.action.holder.serializer.IActionHolderSerializer;
import com.daqem.arc.api.action.holder.type.IActionHolderType;
import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.itemrestrictions.data.ItemRestrictionManager;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.conditions.job.IJobCondition;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class JobInstance
extends AbstractActionHolder {
    private final int price;
    private final int maxLevel;
    private final String color;
    private final ItemStack iconItem;
    private final ResourceLocation powerupBackground;
    private final boolean isDefault;

    public JobInstance(ResourceLocation location, int price, int maxLevel, String color, ItemStack iconItem, ResourceLocation powerupBackground, boolean isDefault) {
        this(location, price, maxLevel, color, iconItem, powerupBackground, isDefault, new ArrayList<PowerupInstance>());
    }

    public JobInstance(ResourceLocation location, int price, int maxLevel, String color, ItemStack iconItem, ResourceLocation powerupBackground, boolean isDefault, List<PowerupInstance> powerupInstances) {
        super(location);
        this.price = price;
        this.maxLevel = maxLevel;
        this.color = color;
        this.iconItem = iconItem;
        this.powerupBackground = powerupBackground;
        this.isDefault = isDefault;
    }

    public int getPrice() {
        return this.price;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public MutableComponent getName() {
        return JobsPlus.translatable("job." + this.location.getNamespace() + "." + this.location.getPath() + ".name");
    }

    public MutableComponent getDescription() {
        return JobsPlus.translatable("job." + this.location.getNamespace() + "." + this.location.getPath() + ".description");
    }

    public List<PowerupInstance> getPowerups() {
        return ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> {
            PowerupInstance powerupInstance;
            return actionHolder instanceof PowerupInstance && (powerupInstance = (PowerupInstance)((Object)actionHolder)).getJobLocation().equals((Object)this.location);
        }).map(actionHolder -> (PowerupInstance)((Object)actionHolder)).collect(Collectors.toList());
    }

    public int getColorDecimal() {
        return Integer.parseInt(this.color.replace("#", ""), 16);
    }

    public ItemStack getIconItem() {
        return this.iconItem;
    }

    public ResourceLocation getPowerupBackground() {
        return this.powerupBackground;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Map<ItemRestriction, Integer> getItemRestrictions() {
        return ItemRestrictionManager.getInstance().getItemRestrictions().stream().filter(itemRestriction -> itemRestriction.getConditions().stream().anyMatch(condition -> {
            IJobCondition jobCondition;
            return condition instanceof IJobCondition && (jobCondition = (IJobCondition)condition).getJobLocation().equals((Object)this.location);
        })).collect(Collectors.toMap(itemRestriction -> itemRestriction, itemRestriction -> itemRestriction.getConditions().stream().filter(condition -> condition instanceof IJobCondition).map(iCondition -> ((IJobCondition)iCondition).getRequiredLevel()).max(Integer::compareTo).orElse(0)));
    }

    public IActionHolderType<?> getType() {
        return JobsPlusActionHolderType.JOB_INSTANCE;
    }

    @Nullable
    public static JobInstance of(ResourceLocation location) {
        return JobManager.getInstance().getJobs().get(location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JobInstance)) return false;
        JobInstance jobInstance = (JobInstance)((Object)obj);
        if (!jobInstance.location.equals((Object)this.location)) return false;
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<JobInstance>,
    IActionHolderSerializer<JobInstance> {
        public JobInstance deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = element.getAsJsonObject();
            return this.fromJson(jsonObject, this.getResourceLocation(jsonObject, "location"));
        }

        public JobInstance fromJson(JsonObject jsonObject, ResourceLocation resourceLocation) {
            return new JobInstance(resourceLocation, GsonHelper.getAsInt((JsonObject)jsonObject, (String)"price"), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"max_level"), GsonHelper.getAsString((JsonObject)jsonObject, (String)"color"), this.getItemStack((JsonElement)GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"icon")), ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"background", (String)"minecraft:textures/block/stone.png")), GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"is_default", (boolean)false));
        }

        public JobInstance fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf, ResourceLocation resourceLocation) {
            return new JobInstance(friendlyByteBuf.readResourceLocation(), friendlyByteBuf.readVarInt(), friendlyByteBuf.readVarInt(), friendlyByteBuf.readUtf(), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf), friendlyByteBuf.readResourceLocation(), friendlyByteBuf.readBoolean());
        }

        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, JobInstance jobInstance) {
            friendlyByteBuf.writeResourceLocation(jobInstance.location);
            friendlyByteBuf.writeVarInt(jobInstance.price);
            friendlyByteBuf.writeVarInt(jobInstance.maxLevel);
            friendlyByteBuf.writeUtf(jobInstance.color);
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)jobInstance.iconItem);
            friendlyByteBuf.writeResourceLocation(jobInstance.powerupBackground);
            friendlyByteBuf.writeBoolean(jobInstance.isDefault);
            super.toNetwork(friendlyByteBuf, (IActionHolder)jobInstance);
        }
    }
}

