/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.holder.holders.job;

import com.daqem.arc.api.action.holder.AbstractActionHolder;
import com.daqem.arc.api.action.holder.ActionHolderManager;
import com.daqem.jobsplus.JobsPlusExpectPlatform;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.type.JobsPlusActionHolderType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class JobManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(JobInstance.class, (Object)new JobInstance.Serializer()).create();
    public static final Logger LOGGER = LogUtils.getLogger();
    private static JobManager instance;

    public JobManager() {
        super(GSON, "jobsplus/jobs");
        instance = this;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        ActionHolderManager actionHolderManager = ActionHolderManager.getInstance();
        actionHolderManager.clearAllActionHoldersForType(JobsPlusActionHolderType.JOB_INSTANCE);
        HashMap tempJobInstances = new HashMap();
        map.forEach((location, jsonElement) -> {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                jsonObject.addProperty("location", location.toString());
                JobInstance job = (JobInstance)((Object)((Object)GSON.fromJson((JsonElement)jsonObject, JobInstance.class)));
                if (!job.isDefault() || job.isDefault() && ((Boolean)JobsPlusConfig.enableDefaultJobs.get()).booleanValue()) {
                    tempJobInstances.put(location, job);
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not deserialize job {} because: {}", (Object)location.toString(), (Object)e.getMessage());
            }
        });
        LOGGER.info("Loaded {} jobs", (Object)tempJobInstances.size());
        actionHolderManager.registerActionHolders(new ArrayList(tempJobInstances.values()));
    }

    public static JobManager getInstance() {
        return instance != null ? instance : JobsPlusExpectPlatform.getJobManager();
    }

    public Map<ResourceLocation, JobInstance> getJobs() {
        return ActionHolderManager.getInstance().getActionHolders().stream().filter(actionHolder -> actionHolder instanceof JobInstance).map(actionHolder -> (JobInstance)((Object)actionHolder)).collect(Collectors.toMap(AbstractActionHolder::getLocation, jobInstance -> jobInstance));
    }
}

