/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.mixin.client;

import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.client.player.JobsClientPlayer;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobManager;
import com.daqem.jobsplus.networking.c2s.ServerboundRequestJobsPacket;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class MixinLocalPlayer
extends AbstractClientPlayer
implements JobsClientPlayer {
    @Unique
    private final List<Job> jobsplus$jobs = new ArrayList<Job>();
    @Unique
    private double jobsplus$coins = 0.0;

    public MixinLocalPlayer(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Override
    public List<Job> jobsplus$getJobs() {
        return this.jobsplus$jobs;
    }

    @Override
    public List<JobInstance> jobsplus$getJobInstances() {
        return this.jobsplus$jobs.stream().map(Job::getJobInstance).toList();
    }

    @Override
    public List<Job> jobsplus$getInactiveJobs() {
        return JobManager.getInstance().getJobs().values().stream().filter(jobInstance -> !this.jobsplus$getJobInstances().contains(jobInstance)).map(jobInstance -> new Job(this, (JobInstance)((Object)jobInstance))).toList();
    }

    @Override
    @Nullable
    public Job jobsplus$addNewJob(JobInstance jobInstance) {
        if (jobInstance.getLocation() == null) {
            return null;
        }
        Job job = this.jobsplus$getJob(jobInstance);
        if (job == null) {
            job = new Job(this, jobInstance, 1, 0.0);
            this.jobsplus$jobs.add(job);
            return job;
        }
        return null;
    }

    @Override
    public void jobsplus$removeJob(JobInstance jobInstance) {
        Job job = this.jobsplus$getJob(jobInstance);
        if (job != null) {
            this.jobsplus$jobs.remove(job);
            this.jobsplus$removeActionHolders(job);
        }
    }

    @Override
    public void jobsplus$removeActionHolders(Job job) {
        LocalPlayer localPlayer = this.jobsplus$getLocalPlayer();
        if (localPlayer instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)localPlayer;
            arcPlayer.arc$removeActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().forEach(powerup -> arcPlayer.arc$removeActionHolder((IActionHolder)powerup.getPowerupInstance()));
        }
    }

    @Override
    public Job jobsplus$getJob(@Nullable JobInstance jobLocation) {
        return this.jobsplus$jobs.stream().filter(job -> job.getJobInstance().equals((Object)jobLocation)).findFirst().orElse(null);
    }

    @Override
    public double jobsplus$getCoins() {
        return this.jobsplus$coins;
    }

    @Override
    public void jobsplus$addCoins(double coins) {
        this.jobsplus$coins = Mth.clamp((double)(this.jobsplus$coins + coins), (double)0.0, (double)2.147483647E9);
    }

    @Override
    public void jobsplus$setCoins(double coins) {
        this.jobsplus$coins = coins;
    }

    @Override
    public String jobsplus$getName() {
        return this.jobsplus$getLocalPlayer().getName().getString();
    }

    @Override
    public Player jobsplus$getPlayer() {
        return this.jobsplus$getLocalPlayer();
    }

    @Override
    public List<IActionHolder> jobsplus$getActionHolders() {
        ArrayList<JobInstance> actionHolders = new ArrayList<JobInstance>(this.jobsplus$getJobInstances());
        actionHolders.addAll(this.jobsplus$getJobs().stream().map(Job::getPowerupManager).flatMap(powerupManager -> powerupManager.getAllPowerups().stream()).map(Powerup::getPowerupInstance).toList());
        return actionHolders;
    }

    @Override
    public LocalPlayer jobsplus$getLocalPlayer() {
        return (LocalPlayer)this;
    }

    @Override
    public void jobsplus$replaceJobs(List<Job> jobs) {
        this.jobsplus$jobs.clear();
        this.jobsplus$jobs.addAll(jobs);
        LocalPlayer localPlayer = this.jobsplus$getLocalPlayer();
        if (localPlayer instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)localPlayer;
            for (int i = arcPlayer.arc$getActionHolders().size() - 1; i >= 0; --i) {
                IActionHolder actionHolder = (IActionHolder)arcPlayer.arc$getActionHolders().get(i);
                if (!(actionHolder instanceof JobInstance)) continue;
                JobInstance jobInstance = (JobInstance)actionHolder;
                arcPlayer.arc$removeActionHolder((IActionHolder)jobInstance);
            }
            arcPlayer.arc$addActionHolders(this.jobsplus$getActionHolders());
        }
    }

    @Override
    public void jobsplus$replaceJob(Job job) {
        this.jobsplus$jobs.remove(this.jobsplus$getJob(job.getJobInstance()));
        this.jobsplus$jobs.add(job);
        LocalPlayer localPlayer = this.jobsplus$getLocalPlayer();
        if (localPlayer instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)localPlayer;
            arcPlayer.arc$removeActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().forEach(powerup -> arcPlayer.arc$removeActionHolder((IActionHolder)powerup.getPowerupInstance()));
            arcPlayer.arc$addActionHolder((IActionHolder)job.getJobInstance());
            job.getPowerupManager().getAllPowerups().stream().filter(powerup -> powerup.getState() == PowerupState.ACTIVE).forEach(powerup -> arcPlayer.arc$addActionHolder((IActionHolder)powerup.getPowerupInstance()));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"respawn()V"})
    public void restoreFrom(CallbackInfo ci) {
        NetworkManager.sendToServer((CustomPacketPayload)new ServerboundRequestJobsPacket());
    }
}

