/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.sync.job;

import com.daqem.jobsplus.client.player.JobsClientPlayer;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClientboundUpdateJobPacket
implements CustomPacketPayload {
    private final Job job;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateJobPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateJobPacket>(){

        @NotNull
        public ClientboundUpdateJobPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundUpdateJobPacket((FriendlyByteBuf)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundUpdateJobPacket packet) {
            Job.Serializer.toNetwork((FriendlyByteBuf)buf, packet.job);
        }
    };

    public ClientboundUpdateJobPacket(Job job) {
        this.job = job;
    }

    public ClientboundUpdateJobPacket(FriendlyByteBuf friendlyByteBuf) {
        JobsPlayer player = null;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer instanceof JobsPlayer) {
            JobsPlayer jobsPlayer;
            player = jobsPlayer = (JobsPlayer)localPlayer;
        }
        this.job = Job.Serializer.fromNetwork(friendlyByteBuf, player);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.CLIENTBOUND_UPDATE_JOB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientboundUpdateJobPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player instanceof JobsClientPlayer) {
            JobsClientPlayer player2 = (JobsClientPlayer)player;
            player2.jobsplus$replaceJob(packet.job);
        }
    }
}

