/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.networking.sync.job;

import com.daqem.jobsplus.client.player.JobsClientPlayer;
import com.daqem.jobsplus.networking.JobsPlusNetworking;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.job.Job;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ClientboundUpdateJobsPacket
implements CustomPacketPayload {
    private final List<Job> jobs;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateJobsPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientboundUpdateJobsPacket>(){

        @NotNull
        public ClientboundUpdateJobsPacket decode(RegistryFriendlyByteBuf buf) {
            return new ClientboundUpdateJobsPacket((FriendlyByteBuf)buf);
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientboundUpdateJobsPacket packet) {
            buf.writeCollection(packet.jobs, Job.Serializer::toNetwork);
        }
    };

    public ClientboundUpdateJobsPacket(List<Job> jobs) {
        this.jobs = jobs;
    }

    public ClientboundUpdateJobsPacket(FriendlyByteBuf friendlyByteBuf) {
        JobsPlayer jobsPlayer;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        JobsPlayer player = localPlayer instanceof JobsPlayer ? (jobsPlayer = (JobsPlayer)localPlayer) : null;
        this.jobs = friendlyByteBuf.readList(friendlyByteBuf1 -> Job.Serializer.fromNetwork(friendlyByteBuf1, player));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return JobsPlusNetworking.CLIENTBOUND_UPDATE_JOBS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSide(ClientboundUpdateJobsPacket packet, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (player instanceof JobsClientPlayer) {
            JobsClientPlayer player2 = (JobsClientPlayer)player;
            player2.jobsplus$replaceJobs(packet.jobs);
        }
    }
}

