/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.player.job.powerup;

import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsPlayer;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class JobPowerupManager {
    private final List<Powerup> powerups;

    public JobPowerupManager(@NotNull List<Powerup> powerups) {
        this.powerups = powerups;
    }

    public Optional<Powerup> getPowerup(PowerupInstance powerupInstance) {
        return this.powerups.stream().filter(powerup -> powerup.getPowerupInstance().getLocation().equals((Object)powerupInstance.getLocation())).findFirst();
    }

    public List<Powerup> getAllPowerups() {
        return this.powerups;
    }

    public boolean addPowerup(JobsPlayer player, Job job, PowerupInstance powerupInstance) {
        return this.addPowerup(player, job, powerupInstance, PowerupState.ACTIVE);
    }

    public boolean addPowerup(JobsPlayer player, Job job, PowerupInstance powerupInstance, PowerupState powerupState) {
        if (this.canAddPowerup(powerupInstance)) {
            this.powerups.add(new Powerup(powerupInstance, powerupState));
            this.sendJobUpdatePacket(job, player);
            return true;
        }
        return false;
    }

    private void sendJobUpdatePacket(Job job, JobsPlayer player) {
        if (player instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)player;
            jobsServerPlayer.jobsplus$updateJob(job);
        }
    }

    public boolean canAddPowerup(PowerupInstance powerupInstance) {
        if (this.powerups.stream().anyMatch(powerup -> powerup.getPowerupInstance().getLocation().equals((Object)powerupInstance.getLocation()))) {
            return false;
        }
        if (powerupInstance.getParent() == null) {
            return true;
        }
        return this.getPowerup(powerupInstance.getParent()).isPresent();
    }

    public void forceAddPowerup(JobsPlayer player, Job job, PowerupInstance powerupInstance, PowerupState powerupState) {
        this.powerups.add(new Powerup(powerupInstance, powerupState));
        this.sendJobUpdatePacket(job, player);
    }

    public void clearPowerups() {
        this.powerups.clear();
    }

    public Optional<Powerup> getParent(PowerupInstance powerupInstance) {
        PowerupInstance parentPowerupInstance = powerupInstance.getParent();
        if (parentPowerupInstance == null) {
            return Optional.empty();
        }
        return this.getPowerup(parentPowerupInstance);
    }

    public Optional<Powerup> getParent(Powerup powerup) {
        PowerupInstance parentPowerupInstance = powerup.getPowerupInstance().getParent();
        if (parentPowerupInstance == null) {
            return Optional.empty();
        }
        return this.getPowerup(parentPowerupInstance);
    }

    public List<Powerup> getChildren(PowerupInstance powerupInstance) {
        return JobPowerupManager.getChildren(powerupInstance, this.powerups);
    }

    public List<Powerup> getChildren(Powerup powerup) {
        return JobPowerupManager.getChildren(powerup, this.powerups);
    }

    public static List<Powerup> getChildren(PowerupInstance powerupInstance, List<Powerup> powerups) {
        return powerups.stream().filter(powerup -> powerup.getPowerupInstance().getParentLocation() != null && powerup.getPowerupInstance().getParentLocation().equals((Object)powerupInstance.getLocation())).toList();
    }

    public static List<Powerup> getChildren(Powerup powerup, List<Powerup> powerups) {
        return JobPowerupManager.getChildren(powerup.getPowerupInstance(), powerups);
    }
}

