/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.JobsButtonComponent;
import com.daqem.jobsplus.client.components.SpriteComponent;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.event.OnClickEvent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.component.io.ButtonComponent;
import com.daqem.uilib.client.gui.text.Text;
import com.daqem.uilib.client.gui.text.multiline.MultiLineText;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ModalComponent
extends AbstractComponent<ModalComponent> {
    private static final int GAP = 2;
    private static final int BORDER = 6;
    private final SpriteComponent background;
    private final TextComponent title;
    private final TextComponent description;
    private final JobsButtonComponent cancelButton;
    private final JobsButtonComponent confirmButton;

    public ModalComponent(int width) {
        super(null, 0, 0, width, 0);
        this.setVisible(false);
        this.setZ(100);
        Font font = Minecraft.getInstance().font;
        MutableComponent mutableComponent = JobsPlus.literal("");
        Objects.requireNonNull(font);
        Text titleText = new Text(font, (Component)mutableComponent, 0, 0, width - 12, 9);
        MultiLineText descriptionText = new MultiLineText(font, (Component)JobsPlus.literal(""), 0, 0, width - 12);
        titleText.setBold(true);
        titleText.setTextColor(ChatFormatting.DARK_GRAY);
        descriptionText.setTextColor(ChatFormatting.DARK_GRAY);
        this.title = new TextComponent(6, 6, (IText)titleText);
        Objects.requireNonNull(font);
        this.description = new TextComponent(6, 6 + 9 + 2 + 2, (IText)descriptionText);
        this.cancelButton = new JobsButtonComponent(0, 0, (width - 2) / 2, 20, (Component)JobsPlus.translatable("gui.cancel"), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject, screen, mouseX, mouseY, button) -> {
            if (!this.isVisible()) {
                return false;
            }
            this.setVisible(false);
            return true;
        }));
        this.confirmButton = new JobsButtonComponent((width + 2) / 2, 0, (width - 2) / 2, 20, (Component)JobsPlus.translatable("gui.confirm"), (OnClickEvent<ButtonComponent>)((OnClickEvent)(clickedObject, screen, mouseX, mouseY, button) -> {
            if (!this.isVisible()) {
                return false;
            }
            this.setVisible(false);
            return true;
        }));
        this.background = new SpriteComponent(JobsPlus.getId("widget/background"), 0, 0, width, 0);
        this.addChild((IComponent)this.background);
        this.addChild((IComponent)this.title);
        this.addChild((IComponent)this.description);
        this.addChild((IComponent)this.cancelButton);
        this.addChild((IComponent)this.confirmButton);
    }

    public void startRenderable() {
        super.startRenderable();
        this.center();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta, int color) {
        this.renderBlurredBackground();
        this.background.setHeight(this.getBackgroundHeight());
        this.cancelButton.setY(this.getBackgroundHeight() + 2);
        this.confirmButton.setY(this.getBackgroundHeight() + 2);
    }

    public int getHeight() {
        return this.getBackgroundHeight() + 2 + this.cancelButton.getHeight();
    }

    public void close() {
        this.setVisible(false);
        this.getConfirmButton().setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            if (!this.isVisible()) {
                return false;
            }
            this.setVisible(false);
            return true;
        });
    }

    private int getBackgroundHeight() {
        if (this.description.getText() == null) {
            return 0;
        }
        int n = ((MultiLineText)this.description.getText()).getLines().size();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int descriptionHeight = n * 9;
        return 6 + this.title.getHeight() + 2 + 2 + descriptionHeight + 6;
    }

    public boolean preformOnClickEvent(double mouseX, double mouseY, int button) {
        return false;
    }

    private void renderBlurredBackground() {
        Minecraft.getInstance().gameRenderer.processBlurEffect();
    }

    public TextComponent getTitle() {
        return this.title;
    }

    public TextComponent getDescription() {
        return this.description;
    }

    public JobsButtonComponent getConfirmButton() {
        return this.confirmButton;
    }

    public JobsButtonComponent getCancelButton() {
        return this.cancelButton;
    }
}

