/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components;

import com.daqem.jobsplus.client.components.TabPosition;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum TabType {
    ABOVE(new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_left_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_middle_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_right_selected")), new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_left"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_middle"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_right")), 28, 32),
    BELOW(new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_below_left_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_below_middle_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_below_right_selected")), new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_below_left"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_below_middle"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_below_right")), 28, 32),
    LEFT(new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_left_top_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_left_middle_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_left_bottom_selected")), new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_left_top"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_left_middle"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_left_bottom")), 32, 28),
    RIGHT(new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_right_top_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_right_middle_selected"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_right_bottom_selected")), new Sprites(ResourceLocation.withDefaultNamespace((String)"advancements/tab_right_top"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_right_middle"), ResourceLocation.withDefaultNamespace((String)"advancements/tab_right_bottom")), 32, 28);

    private final Sprites selectedSprites;
    private final Sprites unselectedSprites;
    private final int width;
    private final int height;

    private TabType(Sprites selectedSprites, Sprites unselectedSprites, int width, int height) {
        this.selectedSprites = selectedSprites;
        this.unselectedSprites = unselectedSprites;
        this.width = width;
        this.height = height;
    }

    public ResourceLocation getSprite(TabPosition tabPosition) {
        return switch (tabPosition) {
            default -> throw new MatchException(null, null);
            case TabPosition.LEFT -> this.unselectedSprites.first();
            case TabPosition.MIDDLE -> this.unselectedSprites.middle();
            case TabPosition.RIGHT -> this.unselectedSprites.last();
        };
    }

    public ResourceLocation getSelectedSprite(TabPosition tabPosition) {
        return switch (tabPosition) {
            default -> throw new MatchException(null, null);
            case TabPosition.LEFT -> this.selectedSprites.first();
            case TabPosition.MIDDLE -> this.selectedSprites.middle();
            case TabPosition.RIGHT -> this.selectedSprites.last();
        };
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isHorizontal() {
        return this == ABOVE || this == BELOW;
    }

    public boolean isVertical() {
        return this == LEFT || this == RIGHT;
    }

    @OnlyIn(value=Dist.CLIENT)
    record Sprites(ResourceLocation first, ResourceLocation middle, ResourceLocation last) {
    }
}

