/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.jobs;

import com.daqem.jobsplus.client.components.jobs.JobsScrollItemComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.client.screen.job.tab.LeftTab;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.component.scroll.ScrollOrientation;
import com.daqem.uilib.api.client.gui.texture.ITexture;
import com.daqem.uilib.client.gui.component.scroll.ScrollBarComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollContentComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollPanelComponent;
import com.daqem.uilib.client.gui.component.scroll.ScrollWheelComponent;
import com.daqem.uilib.client.gui.texture.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public class JobsScrollComponent
extends ScrollPanelComponent {
    private static final int SCROLL_BAR_WIDTH = 12;
    private static final int SCROLL_BAR_BORDER = 1;
    private static final int SCROLL_BAR_MARGIN = 3;
    private final JobsScreenOptions options;
    private final ScrollContentComponent scrollContent;
    private final List<IComponent<?>> allJobs = new ArrayList();
    private final List<IComponent<?>> preformingJobs = new ArrayList();
    private final List<IComponent<?>> notPreformingJobs = new ArrayList();
    private LeftTab selectedLeftTab;

    public JobsScrollComponent(int x, int y, int width, int height, JobsScreenOptions options) {
        super((ITexture)Textures.SCROLL_PANE, x, y, width, height, ScrollOrientation.VERTICAL);
        this.options = options;
        this.selectedLeftTab = options.getSelectedLeftTab();
        this.scrollContent = new ScrollContentComponent(0, 0, 0, ScrollOrientation.VERTICAL);
        ScrollWheelComponent scrollWheel = new ScrollWheelComponent(Textures.SCROLL_WHEEL, 0, 0, 12);
        ScrollBarComponent scrollBar = new ScrollBarComponent(width + 3 + 1, 1, 12, height - 2, ScrollOrientation.VERTICAL, scrollWheel);
        for (Job job : options.getJobs()) {
            JobsScrollItemComponent item = new JobsScrollItemComponent(0, 0, width, 35, options, job);
            this.scrollContent.addChild((IComponent)item);
            this.allJobs.add((IComponent<?>)item);
            if (job.getLevel() > 0) {
                this.preformingJobs.add((IComponent<?>)item);
                continue;
            }
            this.notPreformingJobs.add((IComponent<?>)item);
        }
        this.setScrollBar(scrollBar);
        this.setScrollContentComponent(this.scrollContent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta, int color) {
        if (this.options.getSelectedLeftTab() != this.selectedLeftTab) {
            this.selectedLeftTab = this.options.getSelectedLeftTab();
            switch (this.options.getSelectedLeftTab()) {
                case ALL: {
                    this.scrollContent.setChildren(this.allJobs);
                    break;
                }
                case PREFORMING: {
                    this.scrollContent.setChildren(this.preformingJobs);
                    break;
                }
                case NOT_PREFORMING: {
                    this.scrollContent.setChildren(this.notPreformingJobs);
                }
            }
            this.getScrollBar().ifPresent(s -> s.scroll((ScrollPanelComponent)this, (double)this.getTotalX(), (double)this.getTotalY()));
            this.getScrollContentComponent().ifPresent(s -> s.scroll((ScrollPanelComponent)this, (double)this.getTotalX(), (double)this.getTotalY()));
        }
        super.render(graphics, mouseX, mouseY, delta, color);
    }
}

