/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.jobs;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.jobs.JobsEmblemComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.config.JobsPlusConfig;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.api.client.gui.texture.INineSlicedTexture;
import com.daqem.uilib.client.gui.component.ItemComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.component.texture.NineSlicedTextureComponent;
import com.daqem.uilib.client.gui.text.Text;
import com.daqem.uilib.client.gui.texture.Textures;
import com.daqem.uilib.client.util.SoundManager;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class JobsScrollItemComponent
extends NineSlicedTextureComponent {
    private final JobsScreenOptions options;
    private final Job job;

    public JobsScrollItemComponent(int x, int y, int width, int height, JobsScreenOptions options, Job job) {
        super((INineSlicedTexture)Textures.SCROLL_BAR_BACKGROUND, x, y, width, height);
        this.options = options;
        this.job = job;
        int activeJobs = (int)options.getJobs().stream().filter(j -> j.getLevel() > 0).count();
        int jobCost = activeJobs >= (Integer)JobsPlusConfig.amountOfFreeJobs.get() ? job.getJobInstance().getPrice() : 0;
        Text jobName = new Text(Minecraft.getInstance().font, (Component)job.getJobInstance().getName());
        Text wantJob = new Text(Minecraft.getInstance().font, (Component)JobsPlus.translatable("gui.want_this_job"));
        Text price = new Text(Minecraft.getInstance().font, (Component)JobsPlus.translatable("gui.price", JobsPlus.literal(String.valueOf(jobCost)).withStyle(ChatFormatting.WHITE), JobsPlus.translatable("gui.price.coins").withStyle(ChatFormatting.WHITE)));
        Text level = new Text(Minecraft.getInstance().font, (Component)JobsPlus.translatable("gui.level", JobsPlus.literal(String.valueOf(job.getLevel())).withStyle(ChatFormatting.WHITE)));
        Text experience = new Text(Minecraft.getInstance().font, (Component)JobsPlus.translatable("gui.exp", JobsPlus.literal((double)Math.round(job.getExperiencePercentage() * 10.0) / 10.0 + "%").withStyle(ChatFormatting.WHITE)));
        jobName.setBold(true);
        jobName.setTextColor(job.getLevel() > 0 ? ChatFormatting.GREEN : ChatFormatting.RED);
        wantJob.setTextColor(ChatFormatting.AQUA);
        price.setTextColor(ChatFormatting.AQUA);
        level.setTextColor(ChatFormatting.AQUA);
        experience.setTextColor(ChatFormatting.AQUA);
        this.addChild((IComponent)new JobsEmblemComponent(3, 5, job));
        this.addChild((IComponent)new ItemComponent(8, 10, job.getJobInstance().getIconItem(), true));
        this.addChild((IComponent)new TextComponent(33, 4, (IText)jobName));
        if (job.getLevel() > 0) {
            this.addChild((IComponent)new TextComponent(33, 15, (IText)level));
            this.addChild((IComponent)new TextComponent(33, 24, (IText)experience));
        } else {
            this.addChild((IComponent)new TextComponent(33, 15, (IText)wantJob));
            this.addChild((IComponent)new TextComponent(33, 24, (IText)price));
        }
        this.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            if (Objects.requireNonNull(Objects.requireNonNull(this.getParent()).getParent()).isTotalHovered(mouseX, mouseY)) {
                options.setSelectedJob(job);
                SoundManager.playUIClick();
                return true;
            }
            return false;
        });
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta, int color) {
        if (this.options.getSelectedJob() == this.job) {
            color = ARGB.colorFromFloat((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
        } else if (this.isTotalHovered(mouseX, mouseY)) {
            color = ARGB.colorFromFloat((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        }
        super.render(graphics, mouseX, mouseY, delta, color);
    }

    public Job getJob() {
        return this.job;
    }
}

