/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.powerup;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.powerup.PowerupHoverBarComponent;
import com.daqem.jobsplus.client.components.powerup.PowerupIconComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.client.textures.JobsPlusTextures;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.daqem.jobsplus.player.job.powerup.PowerupType;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.api.client.gui.text.IText;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import com.daqem.uilib.client.gui.component.TextComponent;
import com.daqem.uilib.client.gui.text.Text;
import com.daqem.uilib.client.gui.text.TruncatedText;
import com.daqem.uilib.client.gui.text.multiline.MultiLineText;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class PowerupHoverComponent
extends AbstractComponent<PowerupHoverComponent> {
    private static final int MIN_WIDTH = 140;
    private static final int MAX_WIDTH = 260;
    private static final int TITLE_X = 28;
    private static final int TITLE_Y = 8;
    private final MultiLineText descriptionText;
    private final TextComponent requiredLevelComponent;
    private final TextComponent priceComponent;
    private final TextComponent descriptionComponent;
    private final PowerupHoverBarComponent hoverBarComponent;
    private final PowerupIconComponent iconComponent;
    private final boolean hasStaticHeight;

    public PowerupHoverComponent(int x, int y, Font font, ItemStack itemStack, Component title, Component descriptionText, PowerupState state, PowerupType type, int requiredLevel, int price, JobsScreenOptions options) {
        this(x, y, Mth.clamp((int)(28 + font.width((FormattedText)title)), (int)140, (int)260), font, itemStack, title, descriptionText, state, type, requiredLevel, price, options);
    }

    public PowerupHoverComponent(int x, int y, int width, Font font, ItemStack itemStack, Component title, Component descriptionText, PowerupState state, PowerupType type, int requiredLevel, int price, JobsScreenOptions options) {
        this(x, y, width, -1, font, itemStack, title, descriptionText, state, type, requiredLevel, price, options);
    }

    public PowerupHoverComponent(int x, int y, int width, int height, Font font, ItemStack itemStack, Component title, Component descriptionText, PowerupState state, PowerupType type, int requiredLevel, int price, JobsScreenOptions options) {
        super(null, x, y, 0, 0);
        Objects.requireNonNull(font);
        this.setText((IText)new TruncatedText(font, title, 28, 8, width - 28 - 3, 9));
        this.setWidth(width);
        this.setHeight(height);
        this.requiredLevelComponent = new TextComponent(0, 0, (IText)new Text(font, (Component)JobsPlus.translatable("gui.job.powerup.required_level", requiredLevel), 0, 0));
        Objects.requireNonNull(this.requiredLevelComponent.getText()).setTextColor(ChatFormatting.GRAY);
        this.priceComponent = new TextComponent(0, 0, (IText)new Text(font, (Component)JobsPlus.translatable("gui.job.powerup.price", price), 0, 0));
        Objects.requireNonNull(this.priceComponent.getText()).setTextColor(ChatFormatting.GRAY);
        this.descriptionText = new MultiLineText(Minecraft.getInstance().font, descriptionText, 0, 0, this.getWidth() - 3);
        this.descriptionComponent = new TextComponent(0, 27, (IText)this.descriptionText);
        this.hoverBarComponent = new PowerupHoverBarComponent(-4, 0, this.getWidth(), state);
        this.iconComponent = new PowerupIconComponent(0, 0, itemStack, state, type, options);
        boolean bl = this.hasStaticHeight = height != -1;
        if (!this.hasStaticHeight) {
            this.setHeight(32 + this.getDescriptionHeight());
        }
        this.addChild((IComponent)this.requiredLevelComponent);
        this.addChild((IComponent)this.priceComponent);
        this.addChild((IComponent)this.descriptionComponent);
        this.addChild((IComponent)this.hoverBarComponent);
        this.addChild((IComponent)this.iconComponent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta, int color) {
        if (!this.hasStaticHeight) {
            this.setHeight(32 + this.getDescriptionHeight());
        }
        this.requiredLevelComponent.setY(this.getHeight() + 1);
        this.priceComponent.setY(this.getHeight() + 11);
        graphics.blitSprite(RenderType::guiTextured, JobsPlusTextures.Powerup.POWERUP_TEXT_BOX, -4, 16, this.getWidth(), this.getHeight() + 10);
        graphics.fill(-2, this.getHeight() - 3, this.getWidth(), this.getHeight() - 2, 0x33FFFFFF);
    }

    private int getDescriptionHeight() {
        int n = this.descriptionText.getLines().size();
        Objects.requireNonNull(Minecraft.getInstance().font);
        return n * 9;
    }

    public void setState(PowerupState powerupState) {
        this.hoverBarComponent.setState(powerupState);
        this.iconComponent.setState(powerupState);
    }
}

