/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.components.powerup;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.powerup.PowerupComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.job.powerup.Powerup;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.daqem.jobsplus.player.job.powerup.PowerupType;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.client.gui.component.AbstractComponent;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;

public class PowerupTreeComponent
extends AbstractComponent<PowerupTreeComponent> {
    public static final int PADDING = 30;
    private final JobsScreenOptions options;
    private PowerupComponent rootPowerupComponent;

    public PowerupTreeComponent(int x, int y, int width, int height, JobsScreenOptions options) {
        super(null, x, y, width, height);
        this.options = options;
        this.run();
        int maxWidth = this.getAllPowerupComponents().stream().mapToInt(AbstractComponent::getTotalX).max().orElse(0) + 26;
        int maxHeight = this.getAllPowerupComponents().stream().mapToInt(AbstractComponent::getTotalY).max().orElse(0) + 26;
        this.setWidth(maxWidth);
        this.setHeight(maxHeight);
        this.setOnDragEvent((draggedObject, screen, mouseX, mouseY, button, dragX, dragY) -> {
            if (this.getParent() != null) {
                int parentWidth = this.getParent().getWidth();
                int parentHeight = this.getParent().getHeight();
                int newX = this.getX() + (int)dragX;
                int newY = this.getY() + (int)dragY;
                if (newX - 30 <= 0 && newX + this.getWidth() + 30 >= parentWidth) {
                    this.setX(newX);
                }
                if (newY - 30 <= 0 && newY + this.getHeight() + 30 >= parentHeight) {
                    this.setY(newY);
                }
            }
            return false;
        });
    }

    public List<PowerupComponent> getAllPowerupComponents() {
        return this.rootPowerupComponent.getAllPowerupChildren();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta, int color) {
    }

    public void run() {
        PowerupInstance rootPowerupInstance = new PowerupInstance(JobsPlus.getId(this.options.getSelectedJob().getJobInstance().getLocation().getPath() + "/root"), this.options.getSelectedJob().getJobInstance().getLocation(), null, this.options.getSelectedJob().getJobInstance().getIconItem(), 0, 0, PowerupType.BASIC);
        Powerup rootPowerup = new Powerup(rootPowerupInstance, this.options.getSelectedJob().getLevel() > 0 ? PowerupState.ACTIVE : PowerupState.NOT_OWNED);
        this.rootPowerupComponent = new PowerupComponent(rootPowerup, this, null, null, 0, this.getX(), this.options);
        this.addChild((IComponent)this.rootPowerupComponent);
        this.rootPowerupComponent.firstWalk();
        float f = this.rootPowerupComponent.secondWalk(0.0f, 0, this.rootPowerupComponent.getY());
        if (f < 0.0f) {
            this.rootPowerupComponent.thirdWalk(-f);
        }
        this.rootPowerupComponent.finalizePosition();
    }

    public PowerupComponent getRootPowerupComponent() {
        return this.rootPowerupComponent;
    }
}

