/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.screen.job;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.client.components.ModalClickPasserComponent;
import com.daqem.jobsplus.client.components.ModalComponent;
import com.daqem.jobsplus.client.components.SpriteComponent;
import com.daqem.jobsplus.client.components.jobs.JobsComponent;
import com.daqem.jobsplus.client.options.JobsScreenOptions;
import com.daqem.uilib.api.client.gui.component.IComponent;
import com.daqem.uilib.client.gui.AbstractScreen;
import java.net.URI;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class JobsScreen
extends AbstractScreen {
    private final JobsScreenOptions options;
    @Nullable
    private final Screen previousScreen;
    private SpriteComponent discordIconComponent;
    private ModalComponent modalComponent;
    private ModalClickPasserComponent modalClickPasserComponent;

    public JobsScreen(JobsScreenOptions options, @Nullable Screen previousScreen) {
        super((Component)JobsPlus.translatable("gui.title.jobs"));
        this.options = options;
        this.previousScreen = previousScreen;
    }

    public void startScreen() {
        this.discordIconComponent = new SpriteComponent(JobsPlus.getId("icon/discord"), this.getWidth() - 18, this.getHeight() - 18, 16, 16);
        this.modalComponent = new ModalComponent(200);
        this.modalClickPasserComponent = new ModalClickPasserComponent(this.getWidth(), this.getHeight(), this.modalComponent);
        this.discordIconComponent.setOnClickEvent((clickedObject, screen, mouseX, mouseY, button) -> {
            try {
                Util.getPlatform().openUri(new URI("https://daqem.com/discord"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        });
        this.addComponent((IComponent)this.modalClickPasserComponent);
        this.addComponent((IComponent)new JobsComponent(this.getTitle(), this.options, this.modalComponent, (Screen)this));
        this.addComponent((IComponent)this.discordIconComponent);
        this.addComponent((IComponent)this.modalComponent);
    }

    public void onResizeScreenRepositionComponents(int width, int height) {
        super.onResizeScreenRepositionComponents(width, height);
        this.discordIconComponent.setX(width - 18);
        this.discordIconComponent.setY(height - 18);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBlurredBackground();
    }

    public void onTickScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.modalClickPasserComponent.setWidth(this.getWidth());
        this.modalClickPasserComponent.setHeight(this.getHeight());
    }

    @Nullable
    public Screen getPreviousScreen() {
        return this.previousScreen;
    }

    public void onClose() {
        if (this.modalComponent.isVisible()) {
            this.modalComponent.setVisible(false);
            return;
        }
        if (this.previousScreen != null) {
            Minecraft.getInstance().setScreen(this.previousScreen);
        } else {
            super.onClose();
        }
    }
}

