/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.toast;

import com.daqem.itemrestrictions.data.ItemRestriction;
import com.daqem.jobsplus.JobsPlus;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ItemRestrictionUnlockedToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final long DISPLAY_TIME = 5000L;
    private final List<ItemRestriction> itemRestrictions = new ArrayList<ItemRestriction>();
    private long lastChanged;
    private boolean changed;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;
    private int displayedItemRestrictionIndex;

    @NotNull
    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager toastManager, long l) {
        if (this.changed) {
            this.lastChanged = l;
            this.changed = false;
        }
        this.wantedVisibility = this.itemRestrictions.isEmpty() ? Toast.Visibility.HIDE : ((double)(l - this.lastChanged) >= 5000.0 * toastManager.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW);
        this.displayedItemRestrictionIndex = (int)((double)l / Math.max(1.0, 5000.0 * toastManager.getNotificationDisplayTimeMultiplier() / (double)this.itemRestrictions.size()) % (double)this.itemRestrictions.size());
    }

    public void render(GuiGraphics guiGraphics, Font font, long l) {
        ItemRestriction entry = this.itemRestrictions.get(this.displayedItemRestrictionIndex);
        guiGraphics.blitSprite(RenderType::guiTextured, BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        guiGraphics.drawString(font, entry.getIcon().getHoverName(), 30, 7, -11534256, false);
        guiGraphics.drawString(font, (Component)JobsPlus.translatable("job.item_unlocked.toast"), 30, 18, -16777216, false);
        guiGraphics.renderFakeItem(entry.getIcon(), 8, 8);
    }

    private void addItem(ItemRestriction itemRestriction) {
        this.itemRestrictions.add(itemRestriction);
        this.changed = true;
    }

    public static void addOrUpdate(ToastManager toastManager, ItemRestriction itemRestriction) {
        ItemRestrictionUnlockedToast itemRestrictionUnlockedToast = (ItemRestrictionUnlockedToast)toastManager.getToast(ItemRestrictionUnlockedToast.class, NO_TOKEN);
        if (itemRestrictionUnlockedToast == null) {
            itemRestrictionUnlockedToast = new ItemRestrictionUnlockedToast();
            toastManager.addToast((Toast)itemRestrictionUnlockedToast);
        }
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(toastManager.getMinecraft().level)));
        itemRestrictionUnlockedToast.addItem(itemRestriction);
    }
}

