/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.client.toast;

import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class LevelUpJobToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/recipe");
    private static final long DISPLAY_TIME = 5000L;
    private final List<Entry> jobInstances = new ArrayList<Entry>();
    private long lastChanged;
    private boolean changed;
    private Toast.Visibility wantedVisibility = Toast.Visibility.HIDE;
    private int displayedJobInstanceIndex;

    @NotNull
    public Toast.Visibility getWantedVisibility() {
        return this.wantedVisibility;
    }

    public void update(ToastManager toastManager, long l) {
        if (this.changed) {
            this.lastChanged = l;
            this.changed = false;
        }
        this.wantedVisibility = this.jobInstances.isEmpty() ? Toast.Visibility.HIDE : ((double)(l - this.lastChanged) >= 5000.0 * toastManager.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW);
        this.displayedJobInstanceIndex = (int)((double)l / Math.max(1.0, 5000.0 * toastManager.getNotificationDisplayTimeMultiplier() / (double)this.jobInstances.size()) % (double)this.jobInstances.size());
    }

    public void render(GuiGraphics guiGraphics, Font font, long l) {
        Entry entry = this.jobInstances.get(this.displayedJobInstanceIndex);
        guiGraphics.blitSprite(RenderType::guiTextured, BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        guiGraphics.drawString(font, (Component)entry.jobInstance.getName(), 30, 7, -11534256, false);
        guiGraphics.drawString(font, (Component)JobsPlus.translatable("job.level_up.toast", entry.level), 30, 18, -16777216, false);
        guiGraphics.renderFakeItem(entry.jobInstance.getIconItem(), 8, 8);
    }

    private void addItem(JobInstance jobInstance, int level) {
        this.jobInstances.add(new Entry(jobInstance, level));
        this.changed = true;
    }

    public static void addOrUpdate(ToastManager toastManager, JobInstance jobInstance, int level) {
        LevelUpJobToast levelUpJobToast = (LevelUpJobToast)toastManager.getToast(LevelUpJobToast.class, NO_TOKEN);
        if (levelUpJobToast == null) {
            levelUpJobToast = new LevelUpJobToast();
            toastManager.addToast((Toast)levelUpJobToast);
        }
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)((Level)Objects.requireNonNull(toastManager.getMinecraft().level)));
        levelUpJobToast.addItem(jobInstance, level);
    }

    @OnlyIn(value=Dist.CLIENT)
    record Entry(JobInstance jobInstance, int level) {
    }
}

