/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.command;

import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.command.arguments.EnumArgument;
import com.daqem.jobsplus.command.arguments.JobArgument;
import com.daqem.jobsplus.command.arguments.PowerupArgument;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.integration.arc.holder.holders.powerup.PowerupInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.daqem.jobsplus.player.job.powerup.PowerupState;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class JobCommand {
    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"job").requires(commandSourceStack -> commandSourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).executes(context -> JobCommand.debug((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target_player"))))).executes(context -> JobCommand.debug((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayer())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.literal((String)"level").then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"job", (ArgumentType)JobArgument.job()).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> JobCommand.setLevel((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))))).then(Commands.literal((String)"experience").then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"job", (ArgumentType)JobArgument.job()).then(Commands.argument((String)"experience", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> JobCommand.setExperience((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"), IntegerArgumentType.getInteger((CommandContext)context, (String)"experience")))))))).then(Commands.literal((String)"coins").then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"coins", (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> JobCommand.setCoins((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target_player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"coins"))))))).then(Commands.literal((String)"powerup").then(Commands.argument((String)"target_player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"job", (ArgumentType)JobArgument.job()).then(Commands.argument((String)"powerup", (ArgumentType)PowerupArgument.powerup()).then(Commands.argument((String)"powerup_state", EnumArgument.enumArgument(PowerupState.class)).executes(context -> JobCommand.setPowerup((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"), PowerupArgument.getPowerup(context, "powerup"), (PowerupState)((Object)((Object)context.getArgument("powerup_state", PowerupState.class)))))))).then(Commands.literal((String)"clear").executes(context -> JobCommand.clearPowerups((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target_player"), JobArgument.getJob(context, "job"))))))))).then(Commands.literal((String)"itemtag").executes(context -> {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayer();
            if (serverPlayer != null) {
                serverPlayer.sendSystemMessage((Component)JobsPlus.literal(serverPlayer.getMainHandItem().getTags().map(itemTagKey -> itemTagKey.location().toString()).collect(Collectors.joining(", "))));
            }
            return 0;
        }))).then(Commands.literal((String)"attributes").executes(context -> {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayer();
            if (serverPlayer != null) {
                serverPlayer.getAttributes().getSyncableAttributes().forEach(attribute -> {
                    serverPlayer.sendSystemMessage((Component)JobsPlus.literal(attribute.getAttribute().getRegisteredName() + ": " + attribute.getValue()));
                    attribute.getModifiers().forEach(attributeModifier -> serverPlayer.sendSystemMessage((Component)JobsPlus.literal(String.valueOf(attributeModifier.id()) + ": " + attributeModifier.amount())));
                    serverPlayer.sendSystemMessage((Component)JobsPlus.literal(" "));
                });
            }
            return 0;
        })));
    }

    private static int clearPowerups(CommandSourceStack source, ServerPlayer targetPlayer, JobInstance jobInstance) {
        JobsServerPlayer jobsServerPlayer;
        Job job;
        if (targetPlayer instanceof JobsServerPlayer && (job = (jobsServerPlayer = (JobsServerPlayer)targetPlayer).jobsplus$getJob(jobInstance)) != null) {
            job.getPowerupManager().clearPowerups();
            jobsServerPlayer.jobsplus$updateJob(job);
            source.sendSuccess(() -> JobsPlus.translatable("command.set.powerup.success_clear", jobInstance.getName()), false);
        }
        return 0;
    }

    private static int debug(CommandSourceStack source, ServerPlayer target) {
        if (target instanceof ArcPlayer) {
            ArcPlayer arcPlayer = (ArcPlayer)target;
            arcPlayer.arc$getActionHolders().forEach(actionHolder -> {
                source.sendSuccess(() -> Component.literal((String)actionHolder.getLocation().toString()), false);
                source.sendSuccess(() -> Component.literal((String)("actions: " + actionHolder.getActions().size())), false);
                source.sendSuccess(() -> Component.literal((String)" "), false);
            });
        }
        return 0;
    }

    private static int setPowerup(CommandSourceStack source, ServerPlayer target, JobInstance jobInstance, PowerupInstance powerupInstance, PowerupState powerupState) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            Job job = jobsServerPlayer.jobsplus$getJob(jobInstance);
            job.getPowerupManager().forceAddPowerup(jobsServerPlayer, job, powerupInstance, powerupState);
            source.sendSuccess(() -> JobsPlus.translatable("command.set.powerup.success", powerupInstance.getName(), jobInstance.getName(), powerupState.toString()), false);
        }
        return 1;
    }

    private static int setCoins(CommandSourceStack source, ServerPlayer target, int coins) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            jobsServerPlayer.jobsplus$setCoins(coins);
            source.sendSuccess(() -> JobsPlus.translatable("command.set.coins.success", coins, jobsServerPlayer.jobsplus$getName()), false);
        }
        return 0;
    }

    private static int setExperience(CommandSourceStack source, ServerPlayer target, JobInstance jobInstance, int experience) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            Job job = jobsServerPlayer.jobsplus$getJob(jobInstance);
            if (job != null) {
                int maxExperienceForLevel = Job.getExperienceToLevelUp(job.getLevel());
                if (experience >= maxExperienceForLevel) {
                    source.sendFailure((Component)JobsPlus.translatable("command.set.experience.experience_too_high", maxExperienceForLevel));
                    return experience;
                }
                if (job.getLevel() >= jobInstance.getMaxLevel()) {
                    source.sendFailure((Component)JobsPlus.translatable("command.set.experience.already_max_level"));
                }
                job.setExperience(experience, false);
                source.sendSuccess(() -> JobsPlus.translatable("command.set.experience.success", jobInstance.getName(), experience, jobsServerPlayer.jobsplus$getPlayer().getDisplayName()), false);
            } else {
                source.sendFailure((Component)JobsPlus.translatable("command.does_not_have_job", jobsServerPlayer.jobsplus$getPlayer().getDisplayName(), jobInstance.getName()));
            }
        }
        return 0;
    }

    private static int setLevel(CommandSourceStack source, ServerPlayer target, JobInstance jobInstance, int level) {
        if (target instanceof JobsServerPlayer) {
            JobsServerPlayer jobsServerPlayer = (JobsServerPlayer)target;
            Job job = jobsServerPlayer.jobsplus$getJob(jobInstance);
            if (level == 0) {
                if (job != null) {
                    jobsServerPlayer.jobsplus$removeJob(jobInstance);
                    source.sendSuccess(() -> JobsPlus.translatable("command.set.level.removed_job", jobInstance.getName(), jobsServerPlayer.jobsplus$getPlayer().getDisplayName()), false);
                } else {
                    source.sendFailure((Component)JobsPlus.translatable("command.set.level.does_not_have_job"));
                }
                return 0;
            }
            if (level > jobInstance.getMaxLevel()) {
                source.sendFailure((Component)JobsPlus.translatable("command.set.level.cannot_be_higher_than_max", jobInstance.getMaxLevel()));
                return 0;
            }
            if (job != null) {
                job.setLevel(level);
                source.sendSuccess(() -> JobsPlus.translatable("command.set.level.success", jobInstance.getName(), level, jobsServerPlayer.jobsplus$getPlayer().getDisplayName()), false);
            } else {
                job = jobsServerPlayer.jobsplus$addNewJob(jobInstance);
                if (job != null) {
                    job.setLevel(level);
                    source.sendSuccess(() -> JobsPlus.translatable("command.set.level.success_new_job", jobInstance.getName(), level, jobsServerPlayer.jobsplus$getPlayer().getDisplayName()), false);
                } else {
                    source.sendFailure((Component)JobsPlus.translatable("command.set.level.cannot_add_job"));
                }
            }
        } else {
            source.sendFailure((Component)JobsPlus.translatable("command.set.level.invalid_target"));
        }
        return 0;
    }
}

