/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.config;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.impl.config.ConfigBuilder;

public class JobsPlusConfig {
    public static final IConfigEntry<Boolean> enableDefaultJobs;
    public static final IConfigEntry<Integer> amountOfFreeJobs;
    public static final IConfigEntry<Integer> maxJobs;
    public static final IConfigEntry<Integer> coinsPerLevelUp;
    public static final IConfigEntry<Boolean> isDebug;

    public static void init() {
    }

    static {
        ConfigBuilder config = new ConfigBuilder("jobsplus", "jobsplus-common", ConfigExtension.YAML, ConfigType.COMMON);
        config.push("jobs");
        enableDefaultJobs = config.defineBoolean("enable_default_jobs", true).withComments(new String[]{"if true, the default jobs are enabled. WARNING: setting this to false will erase all the stats for these jobs"});
        amountOfFreeJobs = config.defineInteger("amount_of_free_jobs", 2, 0, Integer.MAX_VALUE).withComments(new String[]{"the amount of free jobs a player can have"});
        maxJobs = config.defineInteger("max_jobs", Integer.MAX_VALUE, 0, Integer.MAX_VALUE).withComments(new String[]{"the maximum amount of jobs a player can have"});
        config.push("coins");
        coinsPerLevelUp = config.defineInteger("coins_per_level_up", 1, 0, Integer.MAX_VALUE).withComments(new String[]{"the amount of coins a player gets when they level up a job"});
        config.pop();
        config.pop();
        config.push("debug");
        isDebug = config.defineBoolean("is_debug", false).withComments(new String[]{"if true, debug mode is enabled"});
        config.pop();
        config.build();
    }
}

