/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.jobsplus.integration.arc.condition.conditions.job;

import com.daqem.arc.api.action.data.ActionData;
import com.daqem.arc.api.action.holder.IActionHolder;
import com.daqem.arc.api.condition.AbstractCondition;
import com.daqem.arc.api.condition.ICondition;
import com.daqem.arc.api.condition.serializer.IConditionSerializer;
import com.daqem.arc.api.condition.type.IConditionType;
import com.daqem.arc.api.player.ArcPlayer;
import com.daqem.jobsplus.JobsPlus;
import com.daqem.jobsplus.integration.arc.condition.conditions.job.IJobCondition;
import com.daqem.jobsplus.integration.arc.condition.type.JobsPlusConditionType;
import com.daqem.jobsplus.integration.arc.holder.holders.job.JobInstance;
import com.daqem.jobsplus.player.JobsServerPlayer;
import com.daqem.jobsplus.player.job.Job;
import com.google.gson.JsonObject;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class JobLevelCondition
extends AbstractCondition
implements IJobCondition {
    private static final String EMPTY_JOB_LOCATION = "jobsplus:empty";
    private final ResourceLocation jobLocation;
    private final int level;

    public JobLevelCondition(boolean inverted, ResourceLocation jobLocation, int level) {
        super(inverted);
        this.jobLocation = jobLocation;
        this.level = level;
    }

    public boolean isMet(ActionData actionData) {
        JobsServerPlayer jobsServerPlayer;
        Job playerJob;
        JobInstance jobInstance;
        if (!this.jobLocation.equals((Object)ResourceLocation.parse((String)EMPTY_JOB_LOCATION))) {
            jobInstance = JobInstance.of(this.jobLocation);
        } else {
            IActionHolder iActionHolder = actionData.getSourceActionHolder();
            if (iActionHolder instanceof JobInstance) {
                JobInstance jobInstance2;
                jobInstance = jobInstance2 = (JobInstance)iActionHolder;
            } else {
                return false;
            }
        }
        int playerJobLevel = 0;
        ArcPlayer arcPlayer = actionData.getPlayer();
        if (arcPlayer instanceof JobsServerPlayer && (playerJob = (jobsServerPlayer = (JobsServerPlayer)arcPlayer).jobsplus$getJob(jobInstance)) != null) {
            playerJobLevel = playerJob.getLevel();
        }
        return playerJobLevel >= this.level;
    }

    public IConditionType<? extends ICondition> getType() {
        return JobsPlusConditionType.JOB_LEVEL;
    }

    @Override
    public ResourceLocation getJobLocation() {
        return this.jobLocation;
    }

    @Override
    public int getRequiredLevel() {
        return this.level;
    }

    public Component getDescription() {
        JobInstance jobInstance = JobInstance.of(this.jobLocation);
        if (jobInstance == null) {
            return JobsPlus.literal("ERROR: Job not found: '" + this.jobLocation.toString() + "'");
        }
        return this.getDescription(new Object[]{jobInstance.getName(), this.level});
    }

    public static class Serializer
    implements IConditionSerializer<JobLevelCondition> {
        public JobLevelCondition fromJson(ResourceLocation location, JsonObject jsonObject, boolean inverted) {
            return new JobLevelCondition(inverted, ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"job", (String)JobLevelCondition.EMPTY_JOB_LOCATION)), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"level"));
        }

        public JobLevelCondition fromNetwork(ResourceLocation location, RegistryFriendlyByteBuf friendlyByteBuf, boolean inverted) {
            return new JobLevelCondition(inverted, friendlyByteBuf.readResourceLocation(), friendlyByteBuf.readInt());
        }

        public void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, JobLevelCondition type) {
            super.toNetwork(friendlyByteBuf, (ICondition)type);
            friendlyByteBuf.writeResourceLocation(type.jobLocation);
            friendlyByteBuf.writeInt(type.level);
        }
    }
}

